/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.IntegralRange;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import java.math.BigInteger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.Node;

abstract class XsIntegralNumber
implements SimpleType,
Cloneable {
    private static Pattern pattern;
    private IntegralRange boundaries = null;

    public XsIntegralNumber(BigInteger initialMinimum, BigInteger initialMaximum) throws SchemaException {
        this.boundaries = new IntegralRange(initialMinimum, initialMaximum);
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            pattern = compiler.compile("^\\s*[-+]?\\s*\\d+\\s*$");
        }
        catch (MalformedPatternException ex) {
            throw new SchemaException(ex);
        }
    }

    @Override
    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        return this.boundaries.newRangeInstance(minExclusive, minInclusive, maxInclusive, maxExclusive);
    }

    public BigInteger getDefaultIntegralValue() throws SchemaException {
        return new BigInteger(this.boundaries.getValidValue());
    }

    public boolean isValid(BigInteger value) {
        return this.boundaries.isValidSemanticValue(value);
    }

    protected static BigInteger parseIntegralNumber(String text) {
        if ((text = text.trim()).startsWith("+")) {
            text = text.substring(1);
        }
        BigInteger result = new BigInteger(text);
        return result;
    }

    @Override
    public boolean isValidValue(String text) {
        Perl5Matcher matcher = new Perl5Matcher();
        if (!matcher.matches(text, pattern)) {
            return false;
        }
        BigInteger val = XsIntegralNumber.parseIntegralNumber(text);
        return this.isValid(val);
    }

    @Override
    public String getValidValue() throws SchemaException {
        BigInteger num = this.getDefaultIntegralValue();
        return num.toString();
    }

    @Override
    public String verifyAndFix(String text) throws SchemaException {
        if (this.isValidValue(text)) {
            return text;
        }
        return this.getValidValue();
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        return false;
    }

    @Override
    public boolean definesElement(String elementName) {
        return false;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return null;
    }
}

