/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.xpath;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathGenerator {
    public static String getXPath(Document node) {
        return "/";
    }

    public static String getXPath(Attr node) {
        StringBuffer buffer = new StringBuffer();
        XPathGenerator.getXPath(node, buffer);
        String result = buffer.toString();
        return result;
    }

    public static String getXPath(Element node) {
        if (node == null) {
            throw new IllegalArgumentException("node may not be null");
        }
        StringBuffer buffer = new StringBuffer();
        XPathGenerator.getXPath(node, buffer);
        String result = buffer.toString();
        return result;
    }

    private static void getXPath(Attr node, StringBuffer buffer) {
        Element elem = node.getOwnerElement();
        XPathGenerator.getXPath(elem, buffer);
        String name = node.getName();
        buffer.append("/@");
        buffer.append(name);
    }

    private static void getXPath(Element node, StringBuffer buffer) {
        Node parent = node.getParentNode();
        if (parent != null && parent instanceof Element) {
            Element parentElement = (Element)parent;
            XPathGenerator.getXPath(parentElement, buffer);
        }
        String name = node.getTagName();
        buffer.append('/');
        buffer.append(name);
        if (parent != null) {
            int childPosition = 0;
            int nbChildren = 0;
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element childElement;
                if (!(child instanceof Element) || !name.equals((childElement = (Element)child).getTagName())) continue;
                ++nbChildren;
                if (childElement != node) continue;
                childPosition = nbChildren;
            }
            if (nbChildren != 1) {
                buffer.append('[');
                buffer.append(childPosition);
                buffer.append(']');
            }
        }
    }
}

