/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.xpath.parsetree;

import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationListener;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationState;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Expression;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.w3c.dom.Node;

public class Element
implements Expression {
    private String namespace;
    private String localName;

    public Element(String namespace, String localName) {
        this.namespace = namespace;
        this.localName = localName;
    }

    @Override
    public LinkedList<EvaluationState> evaluate(Node context, Object state, EvaluationListener listener) {
        LinkedList<EvaluationState> result = new LinkedList<EvaluationState>();
        for (Node child = context.getFirstChild(); child != null; child = child.getNextSibling()) {
            org.w3c.dom.Element childElem;
            if (!(child instanceof org.w3c.dom.Element) || !this.matches(childElem = (org.w3c.dom.Element)child)) continue;
            Object newListenerState = listener.descending(state, context);
            EvaluationState intermediateState = new EvaluationState(child, newListenerState);
            result.add(intermediateState);
        }
        return result;
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.print("  ");
        }
        writer.print("Element namespace=");
        writer.print(this.namespace);
        writer.print(" ");
        writer.print("localname=");
        writer.print(this.localName);
        writer.println();
    }

    private boolean matches(org.w3c.dom.Element elem) {
        String contextLocalName = elem.getLocalName();
        String contextNamespace = elem.getNamespaceURI();
        if (!contextLocalName.equals(this.localName)) {
            return false;
        }
        if ((contextNamespace == null || this.namespace == null) && contextNamespace != this.namespace) {
            return false;
        }
        return contextNamespace == null || contextNamespace.equals(this.namespace);
    }
}

