/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.xpath.parsetree;

import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationListener;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationResult;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationState;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Expression;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Path {
    private boolean allDescendants;
    private Expression[] steps;

    public Path(boolean allDescendants, Expression[] steps) {
        this.allDescendants = allDescendants;
        this.steps = steps;
    }

    public void evaluate(Node context, EvaluationListener listener, EvaluationResult result) {
        if (!this.allDescendants) {
            this.evaluateSteps(context, null, listener, 0, result);
        } else {
            this.evaluateAllDescendants(context, null, listener, result);
        }
    }

    public void dump(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.print("  ");
        }
        writer.println("Path");
        for (int j = 0; j < this.steps.length; ++j) {
            this.steps[j].dump(writer, indent + 1);
        }
    }

    private void evaluateAllDescendants(Node context, Object listenerState, EvaluationListener listener, EvaluationResult result) {
        this.evaluateSteps(context, listenerState, listener, 0, result);
        for (Node child = context.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Object newListenerState = listener.descending(listenerState, child);
            this.evaluateAllDescendants(child, newListenerState, listener, result);
        }
    }

    private void evaluateSteps(Node context, Object listenerState, EvaluationListener listener, int stepPos, EvaluationResult result) {
        if (stepPos >= this.steps.length) {
            Object resultEntry = listener.accept(listenerState, context);
            result.add(resultEntry);
            return;
        }
        LinkedList<EvaluationState> intermediateResults = this.steps[stepPos].evaluate(context, listenerState, listener);
        for (EvaluationState evalState : intermediateResults) {
            Object newListenerState = evalState.getListenerState();
            Node newContext = evalState.getContext();
            this.evaluateSteps(newContext, newListenerState, listener, stepPos + 1, result);
        }
    }
}

