/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.cm_plugin;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.rspecupgrade.internal.io.FileUtils;
import com.cognos.rspecupgrade.rsupgrade.cm_plugin.CmUpgradeFactory;
import com.cognos.rspecupgrade.rsupgrade.cm_plugin.UpgradeReportSpecWorker;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.Configuration;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.IUpgradeReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.UntranslatedMessages;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class UpgradeReportSpec
implements CMUpgradePlugin {
    final UpgradeReportSpecWorker worker = new UpgradeReportSpecWorker(factory);
    static final CmUpgradeFactory factory = new CmUpgradeFactory(){

        @Override
        public Messages createMessages() {
            return new MessagesImpl();
        }

        @Override
        public IConfiguration createConfiguration(Messages translatedMessages) throws UpgradeException {
            return new Configuration(translatedMessages);
        }

        @Override
        public IUpgradeReportSpecification createUpgrader(Messages messages, IConfiguration config) throws UpgradeException {
            return new UpgradeReportSpecification(messages, config);
        }
    };
    private static final String _UTF8 = "UTF-8";
    private static final String PROP_SPECIFICATION = "specification";

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration cfg) throws Exception {
        this.worker.initialize(desc, cfg);
    }

    public void terminate() throws Exception {
        this.worker.terminate();
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) {
        return this.worker.upgrade(data);
    }

    public static void main(String[] args) {
        try {
            File srcFile;
            UntranslatedMessages msgs = new UntranslatedMessages();
            if (args.length != 2) {
                String msg = msgs.getString(RspecUpgradeMessage.RSU_UPG_UPGRADE_REPORT_SPEC_USAGE());
                System.out.println(msg);
                System.exit(1);
            }
            if (!(srcFile = new File(args[0])).isFile()) {
                String output = msgs.getString(RspecUpgradeMessage.RSU_UPG_ORIGINAL_REPORT_FILE_NOT_READABLE(srcFile.getCanonicalPath()));
                throw new Exception(output);
            }
            File destFile = new File(args[1]);
            String inputSpec = FileUtils.readFile(srcFile, _UTF8);
            HashMap<String, String> cmInputMap = new HashMap<String, String>();
            cmInputMap.put(PROP_SPECIFICATION, inputSpec);
            cmInputMap.put("UPGRADE_REPORT", "True");
            CMUpgradeData cmInputData = new CMUpgradeData();
            cmInputData.setData(cmInputMap);
            UpgradeReportSpec m = new UpgradeReportSpec();
            m.initialize(null, null);
            CMUpgradeResult cmResult = m.upgrade(cmInputData);
            List cmResultMessages = cmResult.getMessages();
            int cmResultStatus = cmResult.getUpgradeStatus();
            int cmResultNextAction = cmResult.getNextAction();
            System.out.println("---------------------------------------------");
            System.out.print("Upgrade Status = ");
            System.out.println(cmResultStatus);
            System.out.print("Upgrade Next Action = ");
            System.out.println(cmResultNextAction);
            System.out.println("Upgrade Messages = ");
            if (cmResultMessages != null) {
                ListIterator msgIter = cmResultMessages.listIterator();
                while (msgIter.hasNext()) {
                    CMUpgradeMessage upgradeMessage = (CMUpgradeMessage)msgIter.next();
                    System.out.print("(");
                    System.out.print(upgradeMessage.getSeverity());
                    System.out.print(") ");
                    System.out.println(upgradeMessage.getMessage());
                }
            }
            System.out.println();
            if (cmResultStatus == 1) {
                String sResult = cmResult.getPropertyValue(PROP_SPECIFICATION);
                FileOutputStream v4SpecStream = new FileOutputStream(destFile);
                v4SpecStream.write(sResult.getBytes(_UTF8));
                v4SpecStream.close();
                m.terminate();
                String output = msgs.getString(RspecUpgradeMessage.RSU_UPG_MIGRATION_SUCCESS(destFile.getCanonicalPath()));
                System.out.println(output);
                System.out.println("---------------------------------------------");
                System.exit(0);
            } else {
                String output = msgs.getString(RspecUpgradeMessage.RSU_UPG_ERROR_UPGRADE_FAILED());
                System.out.println(output);
                m.terminate();
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

