/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.configuration;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;

public class UpgradeProperties {
    static Boolean aTrue = new Boolean(true);
    static Boolean aFalse = new Boolean(false);
    private static Hashtable<String, Boolean> defaultBooleanValues;
    private static Hashtable<String, Integer> defaultIntegerValues;
    private static final Hashtable<String, Object> defaultValues;
    private Hashtable<String, Object> properties;

    static Hashtable<String, Boolean> getDefaultBooleanValues() {
        Hashtable<String, Boolean> result = new Hashtable<String, Boolean>();
        result.put("com.cognos.rspecupgrade.rsupgrade.writeIntermediateFiles", aFalse);
        result.put("com.cognos.rspecupgrade.rsupgrade.enableWorkOrder2628", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.enableShareResultSet", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.embedInternalError", aFalse);
        result.put("com.cognos.rspecupgrade.rsupgrade.layoutNameGeneration.30", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.layoutNameGeneration.20", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.layoutNameGeneration.1", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.interactivePageBreakByFrame", aFalse);
        result.put("com.cognos.rspecupgrade.rsupgrade.pageBreakText", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.upgradeInfoMessage", aFalse);
        result.put("com.cognos.rspecupgrade.rsupgrade.validateInput", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.validateOutput", aTrue);
        result.put("com.cognos.rspecupgrade.rsupgrade.rewriteCqe", aFalse);
        result.put("com.cognos.rspecupgrade.rsupgrade.rewriteCrx", aFalse);
        result.put("com.cognos.rspecupgrade.rsupgrade.enableChecksumGenerator", aTrue);
        return result;
    }

    static Hashtable<String, Integer> getDefaultIntegerValues() {
        Hashtable<String, Integer> result = new Hashtable<String, Integer>();
        result.put("com.cognos.rspecupgrade.rsupgrade.maxSchemaFixups", new Integer(1000));
        result.put("com.cognos.rspecupgrade.rsupgrade.numRecentReportSchemasToPreload", new Integer(3));
        return result;
    }

    private static Hashtable<String, Object> getDefaultValues() {
        defaultBooleanValues = UpgradeProperties.getDefaultBooleanValues();
        defaultIntegerValues = UpgradeProperties.getDefaultIntegerValues();
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.putAll(defaultBooleanValues);
        result.putAll(defaultIntegerValues);
        return result;
    }

    private void setDefaultValue(String key, String value) {
        Object valueObject = defaultBooleanValues.containsKey(key) ? (Boolean.parseBoolean(value) ? aTrue : aFalse) : (defaultIntegerValues.containsKey(key) ? new Integer(value) : value);
        this.properties.put(key, valueObject);
    }

    private void setDefaultPropertyValues(Properties defaults) {
        Enumeration<?> keys = defaults.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = defaults.getProperty(key);
            this.setDefaultValue(key, value);
        }
    }

    private void setDefaultProperties(Hashtable<String, Object> defaults) {
        Enumeration<String> keys = defaults.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (this.properties.containsKey(key)) continue;
            Object value = defaults.get(key);
            this.properties.put(key, value);
        }
    }

    public UpgradeProperties(Messages messages, File configurationFile, Properties overrideProperties) throws UpgradeException {
        Properties configurationProperties = this.loadConfigurationProperties(configurationFile);
        Properties systemProperties = System.getProperties();
        if (overrideProperties == null) {
            overrideProperties = new Properties();
        }
        this.properties = new Hashtable();
        this.setDefaultPropertyValues(overrideProperties);
        this.setDefaultPropertyValues(systemProperties);
        this.setDefaultPropertyValues(configurationProperties);
        this.setDefaultProperties(defaultValues);
    }

    public String getString(String key, String defaultValue) {
        String result = this.properties.containsKey(key) ? (String)this.properties.get(key) : defaultValue;
        return result;
    }

    public int getInteger(String key) {
        Integer anInt = (Integer)this.properties.get(key);
        return anInt;
    }

    public boolean getBoolean(String key) {
        Boolean bool = (Boolean)this.properties.get(key);
        return bool;
    }

    public String[] getStringArray(String key) {
        LinkedList<String> arrayContents = new LinkedList<String>();
        int index = 0;
        String arrayEntry = null;
        do {
            String arrayKey;
            if ((arrayEntry = this.getString(arrayKey = UpgradeProperties.buildArrayKey(key, index), null)) == null) continue;
            arrayContents.add(arrayEntry);
            ++index;
        } while (arrayEntry != null);
        String[] result = new String[index];
        for (int i = 0; i < index; ++i) {
            result[i] = (String)arrayContents.get(i);
        }
        return result;
    }

    private static String buildArrayKey(String base, int index) {
        StringBuffer arrayKeyBuffer = new StringBuffer(base);
        arrayKeyBuffer.append('[');
        arrayKeyBuffer.append(index);
        arrayKeyBuffer.append(']');
        String arrayKey = arrayKeyBuffer.toString();
        return arrayKey;
    }

    private Properties loadConfigurationProperties(File configurationFile) {
        ICCLConfiguration cfg;
        String configrationDirString;
        File configurationDir;
        if (configurationFile == null && (configurationDir = new File(configrationDirString = (cfg = CCLConfigurationFactory.getInstance()).resolveEffectivePath("../configuration"))).isDirectory()) {
            configurationFile = new File(configurationDir, "rspecupgrade.properties");
        }
        Properties configurationProperties = new Properties();
        if (configurationFile != null && configurationFile.canRead()) {
            try {
                FileInputStream inputStream = new FileInputStream(configurationFile);
                configurationProperties.load(inputStream);
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return configurationProperties;
    }

    static {
        defaultValues = UpgradeProperties.getDefaultValues();
    }
}

