/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.engine;

import com.cognos.rspecupgrade.internal.io.Glob;
import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.Configuration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._20novrtm.NovRtmNamespaceChanger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BatchUpdater {
    static LinkedList<Work> workToDo = new LinkedList();
    static LinkedList<WorkerThread> workers = new LinkedList();
    static Messages messages = null;
    static int exitCode = 0;
    static boolean novRTM = false;
    static Configuration config = null;

    public static void dumpDebugInformation(String[] args) {
        System.out.println();
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("START DEBUG INFORMATION: com.cognos.rspecupgrade.rsupgrade.internal.engine.BatchUpdater");
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println();
        System.out.print("Java Runtime Environment version: ");
        System.out.println(System.getProperty("java.version"));
        System.out.print("Java Runtime Environment vendor: ");
        System.out.println(System.getProperty("java.vendor"));
        System.out.print("Java vendor URL: ");
        System.out.println(System.getProperty("java.vendor.url"));
        System.out.print("Java installation directory: ");
        System.out.println(System.getProperty("java.home"));
        System.out.print("Java Virtual Machine specification version: ");
        System.out.println(System.getProperty("java.vm.specification.version"));
        System.out.print("Java Virtual Machine specification vendor: ");
        System.out.println(System.getProperty("java.vm.specification.vendor"));
        System.out.print("Java Virtual Machine specification name: ");
        System.out.println(System.getProperty("java.vm.specification.name"));
        System.out.print("Java Virtual Machine implementation version: ");
        System.out.println(System.getProperty("java.vm.version"));
        System.out.print("Java Virtual Machine implementation vendor: ");
        System.out.println(System.getProperty("java.vm.vendor"));
        System.out.print("Java Virtual Machine implementation name: ");
        System.out.println(System.getProperty("java.vm.name"));
        System.out.print("Java Runtime Environment specification version: ");
        System.out.println(System.getProperty("java.specification.version"));
        System.out.print("Java Runtime Environment specification vendor: ");
        System.out.println(System.getProperty("java.specification.vendor"));
        System.out.print("Java Runtime Environment specification name: ");
        System.out.println(System.getProperty("java.specification.name"));
        System.out.print("Java class format version number: ");
        System.out.println(System.getProperty("java.class.version"));
        System.out.print("Java class path: ");
        System.out.println(System.getProperty("java.class.path"));
        System.out.print("Path of extension directory or directories: ");
        System.out.println(System.getProperty("java.ext.dirs"));
        System.out.print("Operating system name: ");
        System.out.println(System.getProperty("os.name"));
        System.out.print("Operating system architecture: ");
        System.out.println(System.getProperty("os.arch"));
        System.out.print("Operating system version: ");
        System.out.println(System.getProperty("os.version"));
        System.out.print("File separator: ");
        System.out.println(System.getProperty("file.separator"));
        System.out.print("Path separator: ");
        System.out.println(System.getProperty("path.separator"));
        System.out.print("Line separator: ");
        System.out.println(System.getProperty("line.separator"));
        System.out.print("User's account name: ");
        System.out.println(System.getProperty("user.name"));
        System.out.print("User's home directory: ");
        System.out.println(System.getProperty("user.home"));
        System.out.print("User's current working directory: ");
        System.out.println(System.getProperty("user.dir"));
        System.out.println();
        System.out.println("arguments:");
        for (int i = 0; i < args.length; ++i) {
            System.out.print(i);
            System.out.print(": ");
            System.out.println(args[i]);
        }
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("END DEBUG INFORMATION: com.cognos.rspecupgrade.rsupgrade.internal.engine.BatchUpdater");
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println();
    }

    private static void help() {
        System.out.println("[--help][--NovRTM=<boolean>][--outdir=<dir>][--indent=<boolean>] [--config=<configurationFile>] [-D<key>=<value>]+ <Report to upgrade>+");
        System.out.println();
        System.out.println("--help");
        System.out.println();
        System.out.println("--NovRTM=<true|false>");
        System.out.println("\tTreat 2.0 reports as Nov RTM");
        System.out.println();
        System.out.println("--outdir=<output directory>");
        System.out.println("\tSpecify directory where upgraded reports will be placed.\n\tUpgraded reports will have the same name as the input.");
        System.out.println();
        System.out.println("--indent=<true|false>");
        System.out.println("\tSpecify if the output will be indented.");
        System.out.println();
        System.out.println("--config=<configurationFile>");
        System.out.println("\tUse the specified configuration file instead of");
        System.out.println("\tconfiguration/rspecupgrade.properties");
        System.out.println();
        System.out.println("-D<key>=<value> Set the property with key to \n");
        System.out.println("\tvalue.  Upgrade defined properties will overwrite");
        System.out.println("\tany system or configuration file properties.");
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            boolean created;
            String msg;
            Messages msgs = BatchUpdater.getMessages();
            BatchUpdater.dumpDebugInformation(args);
            File configFile = null;
            Properties additionalProperties = new Properties();
            boolean indentOutput = true;
            File destDir = null;
            int arg = 0;
            String optNovRTM = "--NovRTM=";
            String optOutDir = "--outdir=";
            String optIndent = "--indent=";
            String optConfig = "--config=";
            while (arg < args.length) {
                String key;
                if (args[arg].equals("--help") || args[arg].equals("-h") || args[arg].equals("-?")) {
                    BatchUpdater.help();
                    System.exit(1);
                    continue;
                }
                if (args[arg].startsWith("--NovRTM=")) {
                    String value = args[arg].substring("--NovRTM=".length());
                    novRTM = Boolean.valueOf(value);
                    ++arg;
                    continue;
                }
                if (args[arg].startsWith("--outdir=")) {
                    String value = args[arg].substring("--outdir=".length());
                    destDir = new File(value);
                    ++arg;
                    continue;
                }
                if (args[arg].startsWith("--indent=")) {
                    String value = args[arg].substring("--indent=".length());
                    indentOutput = Boolean.valueOf(value);
                    ++arg;
                    continue;
                }
                if (args[arg].startsWith("--config=")) {
                    String configFileName = args[arg].substring("--config=".length());
                    configFile = new File(configFileName);
                    if (!configFile.canRead()) {
                        msg = msgs.getString(RspecUpgradeMessage.RSU_UPG_CONFIG_FILE_NOT_READABLE(configFile.getCanonicalPath().toString()));
                        System.out.println(msg);
                        System.exit(1);
                    }
                    ++arg;
                    continue;
                }
                if (!args[arg].startsWith("-D")) break;
                int index = args[arg].indexOf("=");
                String value = "";
                if (index < 0) {
                    key = args[arg].substring(2);
                } else {
                    key = args[arg].substring(2, index);
                    value = args[arg].substring(index + 1);
                }
                additionalProperties.setProperty(key, value);
                ++arg;
            }
            if (destDir == null) {
                String msg2 = msgs.getString(RspecUpgradeMessage.RSU_UPG_BATCH_UPGRADER_USAGE());
                System.out.println(msg2);
                System.exit(1);
            }
            if (!destDir.isDirectory() && !(created = destDir.mkdirs())) {
                msg = msgs.getString(RspecUpgradeMessage.RSU_UPG_ERROR_UNABLE_TO_CREATE_DIRECTORY(destDir.toString()));
                throw new UpgradeException(msg);
            }
            config = new Configuration(msgs, configFile, additionalProperties);
            while (arg < args.length) {
                try {
                    File[] srcFiles = Glob.listFiles(args[arg]);
                    for (int j = 0; j < srcFiles.length; ++j) {
                        BatchUpdater.queueForUpgrade(destDir, srcFiles[j], indentOutput);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    exitCode = 1;
                }
                ++arg;
            }
            String nbWorkersString = System.getProperties().getProperty("com.cognos.rspecupgrade.rsupgrade.internal.engine.BatchUpgrader.workerThreads", "10");
            int nbWorkers = Integer.parseInt(nbWorkersString);
            for (int i = 0; i < nbWorkers; ++i) {
                WorkerThread worker = new WorkerThread();
                workers.addLast(worker);
                worker.start();
            }
            while (!workers.isEmpty()) {
                WorkerThread worker = workers.removeLast();
                worker.join();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = 1;
        }
        System.exit(exitCode);
    }

    private static void queueForUpgrade(File destDir, File v4SpecFile, boolean indentOutput) throws Exception {
        Messages msgs = BatchUpdater.getMessages();
        if (!v4SpecFile.isFile()) {
            String output = msgs.getString(RspecUpgradeMessage.RSU_UPG_ORIGINAL_REPORT_FILE_NOT_READABLE(v4SpecFile.getCanonicalPath()));
            throw new UpgradeException(output);
        }
        File v5SpecFile = new File(destDir, v4SpecFile.getName());
        workToDo.addLast(new Work(v4SpecFile, v5SpecFile, indentOutput));
    }

    static synchronized Messages getMessages() throws Exception {
        if (messages == null) {
            messages = new MessagesImpl();
        }
        return messages;
    }

    static synchronized Work getWork() {
        if (workToDo.isEmpty()) {
            return null;
        }
        return workToDo.removeFirst();
    }

    static class WorkerThread
    extends Thread {
        WorkerThread() {
        }

        private Document getReportToUpgrade(Work work) throws Exception {
            Document origSpec;
            try {
                FileInputStream is = new FileInputStream(work.originalFile);
                InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
                origSpec = XmlUtils.readDocument(reader);
                ((Reader)reader).close();
            }
            catch (IOException ex) {
                String msg = messages.getString(RspecUpgradeMessage.RSU_UPG_INVALID_FILE(work.originalFile.getAbsolutePath(), Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), Integer.toString(ex.getCharacterNumber()), ex.getCause().getLocalizedMessage()));
                throw new Exception(msg, ex);
            }
            if (novRTM) {
                NovRtmNamespaceChanger changer = new NovRtmNamespaceChanger();
                origSpec = changer.upgrade(origSpec);
            }
            return origSpec;
        }

        @Override
        public void run() {
            Work work = null;
            try {
                do {
                    if ((work = BatchUpdater.getWork()) == null) continue;
                    Document origSpec = this.getReportToUpgrade(work);
                    UpgradeReportSpecification upgrader = new UpgradeReportSpecification(messages, config);
                    Document v5Spec = upgrader.upgrade(origSpec);
                    XmlUtils.writeDocument(work.upgradedFile, (Node)v5Spec, work.indentOutput);
                } while (work != null);
            }
            catch (Exception ex) {
                Exception ex2 = new Exception(work.originalFile.getAbsolutePath(), ex);
                ex2.printStackTrace(System.out);
                exitCode = 1;
            }
        }
    }

    static class Work {
        File originalFile;
        File upgradedFile;
        boolean indentOutput;

        Work(File original, File upgraded, boolean indentOutput) {
            this.originalFile = original;
            this.upgradedFile = upgraded;
            this.indentOutput = indentOutput;
        }
    }
}

