/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.engine;

import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParser;
import com.cognos.rspecupgrade.internal.expressionparser.cqe.ICqeParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.io.XslTransformer;
import com.cognos.rspecupgrade.internal.io.XslTransformerImpl;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutTool;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutToolImpl;
import com.cognos.rspecupgrade.internal.xml.XmlComparer;
import com.cognos.rspecupgrade.internal.xml.XmlComparerImpl;
import com.cognos.rspecupgrade.internal.xml.XmlDeleteTool;
import com.cognos.rspecupgrade.internal.xml.XmlDeleteToolImpl;
import com.cognos.rspecupgrade.internal.xml.css.CssParser;
import com.cognos.rspecupgrade.internal.xml.css.CssParserImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.LogImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.SystemLog;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.SystemLogImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.IUpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.UpgradeNotes;
import java.io.Reader;
import java.util.Locale;

public class UpgradeSessionContextImpl
implements UpgradeSessionContext,
Cloneable {
    private IConfiguration config;
    private Log log;
    private SystemLog systemLog;
    private XslTransformer xslTransformer;
    private Messages messages;
    private UpgradeNotes upgradeNotes;
    private XmlComparer xmlComparer;
    private XmlDeleteTool xmlDeleteTool;
    private XmlCommentOutTool xmlCommentOutTool;
    private CssParser cssParser;

    public UpgradeSessionContextImpl(Messages translatedMessages, IConfiguration configuration) throws UpgradeException {
        this.config = configuration;
        this.messages = translatedMessages;
        this.log = new LogImpl(this.messages);
        this.systemLog = new SystemLogImpl();
        this.xslTransformer = new XslTransformerImpl();
        this.xmlComparer = new XmlComparerImpl();
        this.xmlCommentOutTool = new XmlCommentOutToolImpl(this.messages);
        this.xmlDeleteTool = new XmlDeleteToolImpl();
        this.upgradeNotes = new UpgradeNotes(translatedMessages);
        this.cssParser = new CssParserImpl();
        this.xmlComparer.addCompareListener(this.upgradeNotes);
        this.xmlDeleteTool.addListener(this.upgradeNotes);
        this.xmlCommentOutTool.addListener(this.upgradeNotes);
    }

    @Override
    public IConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public SystemLog getSystemLog() {
        return this.systemLog;
    }

    @Override
    public Messages getTranslatedMessages() {
        return this.messages;
    }

    @Override
    public IUpgradeNotes getUpgradeNotes() {
        return this.upgradeNotes;
    }

    @Override
    public XmlComparer getXmlComparer() {
        if (this.xmlComparer == null) {
            // empty if block
        }
        return this.xmlComparer;
    }

    @Override
    public XmlDeleteTool getXmlDeleteTool() {
        return this.xmlDeleteTool;
    }

    @Override
    public XmlCommentOutTool getXmlCommentOutTool() {
        return this.xmlCommentOutTool;
    }

    @Override
    public SchemaModel getReportSpecificationSchemaModel(String namespace) throws UpgradeException {
        return this.config.getSchemaModel(namespace);
    }

    @Override
    public ICqeParser createCqeParser(Reader expression, Locale locale) {
        return new CqeParser(expression, locale);
    }

    @Override
    public CrxParser createCrxParser(Reader expression, Locale locale) throws CrxParserException {
        return new CrxParser(expression, locale, this.messages);
    }

    @Override
    public XslTransformer getXslTransformer() {
        return this.xslTransformer;
    }

    @Override
    public CssParser getCssParser() {
        return this.cssParser;
    }
}

