/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.messages;

import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Message;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplateFramework;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class LogImpl
implements Log {
    private Messages messageFormatter;
    private List<Message> messages = new LinkedList<Message>();
    private Set<Message> messageSet = new HashSet<Message>();
    private boolean messagesAdded = false;

    public LogImpl(Messages messages) {
        this.messageFormatter = messages;
    }

    @Override
    public String error(MessageTemplateFramework messageTemplate) {
        String message = this.messageFormatter.getString(messageTemplate);
        this.doError(message);
        return message;
    }

    @Override
    public String warning(MessageTemplateFramework messageTemplate) {
        String message = this.messageFormatter.getString(messageTemplate);
        this.doWarning(message);
        return message;
    }

    @Override
    public String info(MessageTemplateFramework messageTemplate) {
        String message = this.messageFormatter.getString(messageTemplate);
        this.doInfo(message);
        return message;
    }

    @Override
    public boolean hasMessages() {
        return this.messagesAdded;
    }

    @Override
    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    public boolean hasWarningOrErrorMessages() {
        boolean bErrors = false;
        for (Message msg : this.getMessages()) {
            int severity = msg.getSeverity();
            if (severity != 1 && severity != 0) continue;
            bErrors = true;
            break;
        }
        return bErrors;
    }

    @Override
    public boolean hasErrorMessages() {
        boolean bErrors = false;
        for (Message msg : this.getMessages()) {
            if (msg.getSeverity() != 0) continue;
            bErrors = true;
            break;
        }
        return bErrors;
    }

    public Locale getLocale() {
        return this.messageFormatter.getLocale();
    }

    @Override
    public void logTranslatedMessage(Message message) {
        if (this.messageSet.contains(message)) {
            return;
        }
        this.messages.add(message);
        this.messageSet.add(message);
        this.messagesAdded = true;
    }

    private void doInfo(String txt) {
        Message message = new Message(txt, 2);
        this.logTranslatedMessage(message);
    }

    private void doWarning(String txt) {
        Message message = new Message(txt, 1);
        this.logTranslatedMessage(message);
    }

    private void doError(String txt) {
        Message message = new Message(txt, 0);
        this.logTranslatedMessage(message);
    }

    @Override
    public void remove(Message message) {
        this.messageSet.remove(message);
        this.messages.remove(message);
        if (this.messages.size() == 0) {
            this.messagesAdded = false;
        }
    }
}

