/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._100to110;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification100;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification110;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class vizOutputType
implements UpgradePipelineElement {
    private Document addRequiredOutputTypeForActiveReport(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException, XmlException {
        if (reportSpec == null) {
            throw new UpgradeInternalErrorException("reportSpec document should not be null.");
        }
        try {
            Element layout;
            Element layouts;
            Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification100._report);
            if (report == null) {
                throw new UpgradeInternalErrorException("Document does not have report as root.");
            }
            if (report.hasAttribute(ReportSpecification100._application) && report.getAttribute(ReportSpecification100._application).equalsIgnoreCase("true") && (layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification100._layouts)) != null && (layout = XmlUtils.getFirstChildElementByName(layouts, ReportSpecification100._layout)) != null) {
                NodeList vizNodeList = layout.getElementsByTagName(ReportSpecification100._viz);
                for (int i = 0; i < vizNodeList.getLength(); ++i) {
                    Node viz = vizNodeList.item(i);
                    if (viz == null) continue;
                    Element eElement = (Element)viz;
                    eElement.setAttribute(ReportSpecification110._outputType, "javascript");
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_VIZ_OUTPUTTYPE_CREATED(ReportSpecification110._outputType);
                    String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
                    XmlUtils.insertComment(eElement, translatedMessage);
                }
            }
        }
        catch (DOMException e) {
            UpgradeException.throwNestedException(e);
        }
        return reportSpec;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.addRequiredOutputTypeForActiveReport(origSpec, upgradeSession);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }
}

