/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.FunctionExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.NamespaceContext10x20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AsOfTimeAdjuster
implements UpgradePipelineElement {
    private Locale expressionLocale;

    public AsOfTimeAdjuster(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    @Override
    public Document upgrade(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (this.asOfTimeUsed(v5Spec, upgradeSession)) {
            v5Spec = this.removeBadExpressions(v5Spec, upgradeSession);
        } else {
            NodeList nodes = v5Spec.getElementsByTagName(ReportSpecification20._asOfTime);
            LinkedList<Element> list = new LinkedList<Element>();
            int nbNodes = nodes.getLength();
            for (int i = 0; i < nbNodes; ++i) {
                Element elem = (Element)nodes.item(i);
                list.add(elem);
            }
            for (Element element : list) {
                element.getParentNode().removeChild(element);
            }
        }
        return v5Spec;
    }

    private IExpression parseCrxExpression(Element expressionElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String expressionText = XmlUtils.getText(expressionElement);
        StringReader reader = new StringReader(expressionText);
        IExpression parseTree = null;
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            parseTree = parser.start();
        }
        catch (CrxParserException ex) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CRX_PARSER_ERROR_2(expressionText, ex.getLocalizedMessage());
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)expressionElement, 0, message);
        }
        return parseTree;
    }

    private Document removeBadExpressions(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        LinkedList<Element> toRemove = new LinkedList<Element>();
        BeringQueryFinder queryFinder = new BeringQueryFinder();
        NodeList asOfTimeList = v5Spec.getElementsByTagName(ReportSpecification20._asOfTime);
        int nbElements = asOfTimeList.getLength();
        for (int i = 0; i < nbElements; ++i) {
            Element asOfTimeElement = (Element)asOfTimeList.item(i);
            Element expressionElement = XmlUtils.getFirstChildElementByName(asOfTimeElement, ReportSpecification20._reportExpression);
            IExpression parseTree = this.parseCrxExpression(expressionElement, upgradeSession);
            if (parseTree == null) continue;
            BooleanValue changed1 = new BooleanValue(false);
            if ((parseTree = this.fixQueries(parseTree, expressionElement, queryFinder, changed1)) == null) {
                toRemove.add(asOfTimeElement);
            } else {
                Set<NameExpression> names = GetNames.getNames(parseTree);
                HashSet<String> queriesChecked = new HashSet<String>();
                Iterator<NameExpression> namesIter = names.iterator();
                while (namesIter.hasNext() && parseTree != null) {
                    NameExpression name = namesIter.next();
                    String queryName = name.getQueryName();
                    if (queriesChecked.contains(queryName)) continue;
                    queriesChecked.add(queryName);
                    if (queryFinder.isQueryInScope(queryName, expressionElement)) continue;
                    toRemove.add(asOfTimeElement);
                    parseTree = null;
                }
            }
            if (parseTree == null) continue;
            BooleanValue changed = new BooleanValue(false);
            parseTree = parseTree.optimize(changed);
            String expressionText = parseTree.toString(this.expressionLocale);
            XmlUtils.removeChildren(expressionElement);
            Text expressionTextNode = v5Spec.createTextNode(expressionText);
            expressionElement.appendChild(expressionTextNode);
        }
        for (Element asOfTimeElement : toRemove) {
            Node parent = asOfTimeElement.getParentNode();
            parent.removeChild(asOfTimeElement);
        }
        return v5Spec;
    }

    private IExpression fixQueries(IExpression parseTree, Element context, BeringQueryFinder queryFinder, BooleanValue changed) throws UpgradeException {
        Set<NameExpression> names = GetNames.getNames(parseTree);
        int nbNames = names.size();
        if (nbNames > 0) {
            Hashtable<NameExpression, NameExpression> nameReplacements = new Hashtable<NameExpression, NameExpression>(nbNames);
            for (NameExpression name : names) {
                if (name.getQueryName() != null) continue;
                String dataItem = name.getDataItem();
                String queryName = queryFinder.findQueryName(context, dataItem);
                if (queryName == null) {
                    return null;
                }
                NameExpression newName = new NameExpression();
                newName.add(queryName);
                newName.add(dataItem);
                nameReplacements.put(name, newName);
            }
            try {
                parseTree = parseTree.replace(nameReplacements, changed);
            }
            catch (ParseTreeException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        return parseTree;
    }

    private void getFunctions(Set<FunctionExpression> functions, IExpression parseTree) {
        if (parseTree instanceof FunctionExpression) {
            functions.add((FunctionExpression)parseTree);
        } else {
            Enumeration<IExpression> subExpressions = parseTree.getSubExpressions();
            if (subExpressions != null) {
                while (subExpressions.hasMoreElements()) {
                    IExpression subExpression = subExpressions.nextElement();
                    this.getFunctions(functions, subExpression);
                }
            }
        }
    }

    private boolean asOfTimeUsed(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String path = "/bering:report/bering:layouts//bering:reportExpression";
            NodeList expressionNodes = XmlUtils.selectNodeList(v5Spec, path, NamespaceContext10x20.instance);
            int nbNodes = expressionNodes.getLength();
            for (int i = 0; i < nbNodes; ++i) {
                Element expressionElement = (Element)expressionNodes.item(i);
                IExpression parseTree = this.parseCrxExpression(expressionElement, upgradeSession);
                if (parseTree == null) continue;
                HashSet<FunctionExpression> functions = new HashSet<FunctionExpression>();
                this.getFunctions(functions, parseTree);
                for (FunctionExpression function : functions) {
                    String functionName = function.getName();
                    if (functionName.equalsIgnoreCase("AsOfDate")) {
                        return true;
                    }
                    if (!functionName.equalsIgnoreCase("AsOfTime")) continue;
                    return true;
                }
            }
            return false;
        }
        catch (XPathExpressionException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }
}

