/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticVariables;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BalticConditionalStyleCleaner
implements UpgradePipelineElement {
    private Messages messages;
    private Locale expressionLocale;

    public BalticConditionalStyleCleaner(Messages messages, Locale expressionLocale) {
        this.messages = messages;
        this.expressionLocale = expressionLocale;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (origSpec == null) {
            return origSpec;
        }
        Element report = XmlUtils.getFirstChildElementByName(origSpec, "report");
        if (report == null) {
            return origSpec;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, "layoutList");
        if (layouts == null) {
            return origSpec;
        }
        this.cleanConditionalStyles(layouts, origSpec, upgradeSession);
        return origSpec;
    }

    private void cleanConditionalStyles(Element elem, Document balticDoc, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Node child = elem.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            if (child instanceof Element) {
                Element childElement = (Element)child;
                this.cleanConditionalStyles(childElement, balticDoc, upgradeSession);
            }
            child = nextChild;
        }
        if (!XmlUtils.getName(elem).equals("conditionalStyle")) {
            return;
        }
        Element conditionalStyle = elem;
        String refVariable = conditionalStyle.getAttribute("refVariable");
        String expression = this.getVariableExpression(conditionalStyle, balticDoc);
        if (expression == null) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CONDITIONALSTYLE_REMOVED_VARIABLE_EXPRESSION_MISSING(refVariable);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)conditionalStyle, 1, message);
            try {
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)conditionalStyle, message);
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        } else {
            IExpression expr = null;
            try {
                StringReader reader = new StringReader(expression);
                CrxParser parser = new CrxParser(reader, this.expressionLocale, this.messages);
                expr = parser.start();
            }
            catch (CrxParserException ex) {
                String cause = ex.getMessage();
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CONDITIONALSTYLE_REMOVED_VARIABLE_EXPRESSION_PARSE_FAILURE(refVariable, expression, cause);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)conditionalStyle, 1, message);
                this.replaceWithDefaultStyle(conditionalStyle, message, upgradeSession);
                return;
            }
            this.cleanCrosstabOrChartConditionalStyle(balticDoc, conditionalStyle, refVariable, expr, upgradeSession);
        }
    }

    private String getVariableExpression(Element conditionalStyle, Document balticDoc) {
        Element variable = BalticVariables.getReportVariable(conditionalStyle);
        if (variable == null) {
            return null;
        }
        Element expression = XmlUtils.getFirstChildElementByName(variable, "expression");
        if (expression == null) {
            return null;
        }
        String expressionText = XmlUtils.getText(expression);
        return expressionText;
    }

    private Map<String, Element> getQueryElementMap(Document balticDoc, Vector<String> queryNames) {
        HashMap<String, Element> queryElements = new HashMap<String, Element>();
        for (String queryName : queryNames) {
            Element queryElem = BalticQueryFinder.findQueryElement(balticDoc, queryName);
            if (queryElem == null) continue;
            queryElements.put(queryName, queryElem);
        }
        return queryElements;
    }

    private boolean isDataItemDefined(NameExpression name, Map<String, Element> queryElements, Vector<String> queryNames) {
        boolean itemDefined = false;
        String queryName = name.getQueryName();
        String itemName = name.getDataItem();
        if (queryName != null && queryElements.containsKey(queryName)) {
            Element queryElem = queryElements.get(queryName);
            itemDefined = BalticQueryFinder.queryContainsDataItem(queryElem, itemName);
        } else {
            Iterator<String> queryIter2 = queryNames.iterator();
            while (queryIter2.hasNext() && !itemDefined) {
                queryName = queryIter2.next();
                Element queryElem = queryElements.get(queryName);
                itemDefined = BalticQueryFinder.queryContainsDataItem(queryElem, itemName);
            }
        }
        return itemDefined;
    }

    private void cleanCrosstabOrChartConditionalStyle(Document balticDoc, Element conditionalStyle, String variableName, IExpression variableExpr, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element biQueryElement = BalticQueryFinder.findQueryElement(conditionalStyle);
        if (biQueryElement == null) {
            return;
        }
        if (!BalticQueryFinder.isSummaryQuery(biQueryElement)) {
            return;
        }
        Vector<String> queryNames = BalticQueryFinder.findQueryNamesInContext(conditionalStyle);
        Map<String, Element> queryElements = this.getQueryElementMap(balticDoc, queryNames);
        Set<NameExpression> names = null;
        try {
            names = GetNames.getNames(variableExpr);
        }
        catch (ParseTreeException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
        for (NameExpression name : names) {
            if (this.isDataItemDefined(name, queryElements, queryNames)) continue;
            String itemName = name.getDataItem();
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CONDITIONALSTYLE_REMOVED_ITEM_NOT_DEFINED_IN_QUERY(variableName, itemName);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)conditionalStyle, 1, message);
            this.replaceWithDefaultStyle(conditionalStyle, message, upgradeSession);
            return;
        }
    }

    private void replaceWithDefaultStyle(Element conditionalStyle, MessageTemplate msg, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList styles = XmlUtils.getChildElementsByName(conditionalStyle, "style");
        int nbStyles = styles.getLength();
        Node defaultStyle = null;
        for (int styleNb = 0; defaultStyle == null && styleNb < nbStyles; ++styleNb) {
            Element style = (Element)styles.item(styleNb);
            if (style.hasAttribute("refVariableValue")) continue;
            defaultStyle = style;
        }
        if (defaultStyle != null) {
            Node parent = conditionalStyle.getParentNode();
            Node newStyle = defaultStyle.cloneNode(true);
            parent.insertBefore(newStyle, conditionalStyle);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
            XmlUtils.insertComment(newStyle, translatedMessage);
        }
        try {
            upgradeSession.getXmlCommentOutTool().commentOutNode((Node)conditionalStyle, msg);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }
}

