/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.xpath.XPathGenerator;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BalticDanglingDataItem
implements UpgradePipelineElement {
    BalticQueryFinder queryFinder = new BalticQueryFinder();
    private Locale expressionLocale;

    public BalticDanglingDataItem(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        this.danglingDataItemExpression(origSpec, context);
        return origSpec;
    }

    private void danglingDataItemExpression(Document balticSpec, UpgradeSessionContext context) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(balticSpec, "report");
        if (report == null) {
            return;
        }
        Element layoutList = XmlUtils.getFirstChildElementByName(report, "layoutList");
        if (layoutList == null) {
            return;
        }
        NodeList expressionList = layoutList.getElementsByTagName("expression");
        int nbExpressions = expressionList.getLength();
        for (int experssionNb = 0; experssionNb < nbExpressions; ++experssionNb) {
            Element expressionElement = (Element)expressionList.item(experssionNb);
            this.checkExpressionForDanglingDataItem(expressionElement, context);
        }
    }

    private void checkExpressionForDanglingDataItem(Element expressionElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String expressionText = XmlUtils.getText(expressionElement);
        StringReader reader = new StringReader(expressionText);
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            IExpression parseTree = parser.start();
            Set<NameExpression> refDataItems = GetNames.getNames(parseTree);
            for (NameExpression nameExpression : refDataItems) {
                String dataItem;
                if (nameExpression.getQueryName() != null || !this.isDangling(dataItem = nameExpression.getDataItem(), expressionElement)) continue;
                this.logDanglingDataItem(expressionElement, expressionText, dataItem, upgradeSession);
            }
        }
        catch (CrxParserException crxParserException) {
            // empty catch block
        }
    }

    private boolean isDangling(String dataItem, Element context) {
        String queryName = this.queryFinder.findQueryName(context, dataItem);
        boolean dangling = queryName == null;
        return dangling;
    }

    void addUpgradeNote(Element expressionElement, UpgradeSessionContext upgradeSession, MessageTemplate message) throws UpgradeException {
        upgradeSession.getUpgradeNotes().addUpgradeNote(expressionElement.getParentNode(), 2, message);
    }

    void logDanglingDataItemDefiningQuery(Element expressionElement, String dataItem, String query, UpgradeSessionContext upgradeSession) throws UpgradeException {
        RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DATA_ITEM_DEFINED_IN_QUERY(dataItem, query);
        this.addUpgradeNote(expressionElement, upgradeSession, message);
    }

    public void logDefinedDanglingDataItem(Element expressionElement, String dataItem, Set<String> queries, UpgradeSessionContext upgradeSession) throws UpgradeException {
        TreeSet<String> sortedQueries = new TreeSet<String>(queries);
        for (String query : sortedQueries) {
            this.logDanglingDataItemDefiningQuery(expressionElement, dataItem, query, upgradeSession);
        }
    }

    private void logDanglingDataItem(Element expressionElement, String expressionText, String dataItem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String path = XPathGenerator.getXPath(expressionElement);
        RspecUpgradeMessage mesage = RspecUpgradeMessage.RSU_SPC_BALTIC_DANGLING_REFERENCE_IN_EXPRESSION(expressionText, dataItem, path);
        this.addUpgradeNote(expressionElement, upgradeSession, mesage);
        String translatedMessage = upgradeSession.getTranslatedMessages().getString(mesage);
        XmlUtils.insertComment(expressionElement, translatedMessage);
        Document reportSpecification = XmlUtils.getOwnerDoc(expressionElement);
        BalticQueryFinder queryFinder = new BalticQueryFinder();
        Set<String> queries = queryFinder.findQueriesWithDataItem(reportSpecification, dataItem);
        if (queries.isEmpty()) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_DEFINED_IN_ANY_QUERY(dataItem);
            this.addUpgradeNote(expressionElement, upgradeSession, message);
        } else {
            this.logDefinedDanglingDataItem(expressionElement, dataItem, queries, upgradeSession);
        }
    }
}

