/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticVariables;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BalticTextItemRefVariableCleaner
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        try {
            if (origSpec == null) {
                return origSpec;
            }
            Element report = XmlUtils.getFirstChildElementByName(origSpec, "report");
            if (report == null) {
                return origSpec;
            }
            Element layoutList = XmlUtils.getFirstChildElementByName(report, "layoutList");
            if (layoutList == null) {
                return origSpec;
            }
            FixTextItemExaminer examiner = new FixTextItemExaminer(context);
            DomWalker.bottomUpWalkElements(layoutList, examiner);
            return origSpec;
        }
        catch (XmlException ex) {
            UpgradeException.throwNestedException(ex);
            throw new UpgradeException(ex);
        }
    }

    private class FixTextItemExaminer
    implements DomWalker.Examiner {
        UpgradeSessionContext context;

        FixTextItemExaminer(UpgradeSessionContext aContext) {
            this.context = aContext;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            try {
                Element balticVariable;
                String elementName = XmlUtils.getName(elem);
                if (elementName.equals("textItem") && elem.hasAttribute("refVariable") && (balticVariable = BalticVariables.getReportVariable(elem)) == null) {
                    this.fixTextItem(elem, this.context);
                }
                return DomWalker.SearchOrder.proceed;
            }
            catch (UpgradeException e) {
                XmlException.throwNestedException(e);
                throw new XmlException(e);
            }
        }

        void fixTextItem(Element textItem, final UpgradeSessionContext upgradeSession) throws XmlException, UpgradeException {
            DomWalker.Examiner examiner = new DomWalker.Examiner(){

                @Override
                public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                    String elementName = XmlUtils.getName(elem);
                    if (elementName.equals("text") && elem.hasAttribute("refVariableValue")) {
                        upgradeSession.getXmlCommentOutTool().commentOutNode(elem);
                    }
                    return DomWalker.SearchOrder.proceed;
                }
            };
            DomWalker.walkChildrenElements(textItem, examiner);
            String variableName = textItem.getAttribute("refVariable");
            textItem.removeAttribute("refVariable");
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_TEXTITEM_REFVARIABLE_REMOVED_NO_SUCH_VARIABLE(variableName);
            upgradeSession.getUpgradeNotes().addUpgradeNote(textItem, 1, message, true);
        }
    }
}

