/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.io.XmlValidater;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BalticValidator
implements UpgradePipelineElement {
    private void recordValidatorWarningMessages(Iterator<String> messageIter, int severity, Element target, UpgradeSessionContext upgradeSession) throws UpgradeException {
        while (messageIter.hasNext()) {
            String msg = messageIter.next();
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_V4_VALIDATION_WARNING(msg);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)target, severity, message);
        }
    }

    private void recordValidatorErrorMessages(Iterator<String> messageIter, int severity, Element target, UpgradeSessionContext upgradeSession) throws UpgradeException {
        while (messageIter.hasNext()) {
            String msg = messageIter.next();
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_V4_VALIDATION_ERROR(msg);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)target, severity, message);
        }
    }

    private File getDtdFile(UpgradeSessionContext upgradeSession) throws UpgradeException {
        File binDir = upgradeSession.getConfiguration().getBinDir();
        File rootDir = binDir.getParentFile();
        File schemasDir = new File(rootDir, "schemas");
        File rspecDir = new File(schemasDir, "rspec");
        File rspec10Dir = new File(rspecDir, "1.0");
        File v4DtdFile = new File(rspec10Dir, "report_cr1.dtd");
        if (!v4DtdFile.canRead()) {
            throw new UpgradeInternalErrorException("Unable to find DTD file " + v4DtdFile.getAbsolutePath());
        }
        return v4DtdFile;
    }

    private Document validateAndFix(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Document v4NoNamespace = this.removeNamespace(v4Spec, upgradeSession);
            LinkedList<String> warnings = new LinkedList<String>();
            LinkedList<String> errors = new LinkedList<String>();
            File v4DtdFile = this.getDtdFile(upgradeSession);
            String balticDtd = v4DtdFile.getPath().replace('\\', '/');
            XmlValidater.validateDtd(v4NoNamespace, balticDtd, warnings, errors, upgradeSession.getConfiguration());
            Element root = XmlUtils.getRoot(v4Spec);
            Iterator<String> warningIter = warnings.iterator();
            this.recordValidatorWarningMessages(warningIter, 1, root, upgradeSession);
            Iterator<String> errorIter = errors.iterator();
            this.recordValidatorErrorMessages(errorIter, 0, root, upgradeSession);
            return v4Spec;
        }
        catch (Exception ex) {
            Element root = XmlUtils.getRoot(v4Spec);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_UNEXPECTED_EXCEPTION(ex.getLocalizedMessage());
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)root, 0, message);
            return null;
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        return this.validateAndFix(origSpec, context);
    }

    private Document removeNamespace(Document v4, UpgradeSessionContext upgradeSession) throws Exception {
        StringWriter writer = new StringWriter();
        this.writeDocumentNoNamespace(writer, v4);
        writer.close();
        StringReader reader = new StringReader(writer.toString());
        Document v4NoNamespace = XmlUtils.readDocument(reader);
        XmlUtils.writeIntermediateDocument(v4NoNamespace, "v4NoNamespace", upgradeSession.getConfiguration());
        return v4NoNamespace;
    }

    private void writeDocumentNoNamespace(Writer out, Document v4) throws Exception {
        String oldxslt = "<?xml version=\"1.0\"?><xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"  version=\"1.0\"> <xsl:output method=\"xml\" version=\"1.0\" encoding=\"UTF-8\" indent=\"no\" omit-xml-declaration=\"yes\"/> <xsl:template match=\"/\"><xsl:copy-of select=\"*\"/></xsl:template></xsl:stylesheet>";
        StringReader reader = new StringReader(oldxslt);
        StreamSource src = new StreamSource(reader);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(src);
        Element root = XmlUtils.getRoot(v4);
        String namespace = null;
        if (root.hasAttribute("xmlns")) {
            namespace = root.getAttribute("xmlns");
            root.removeAttribute("xmlns");
        }
        DOMSource source = new DOMSource(v4);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        if (namespace != null) {
            root.setAttribute("xmlns", namespace);
        }
    }
}

