/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.AliasMap;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BeringVariables;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DanglingDataItemTool;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DanglingReferenceConditionalStyleCases
implements UpgradePipelineElement {
    private DanglingDataItemTool danglingDataItemFixer = null;
    private Locale expressionLocale;

    public DanglingReferenceConditionalStyleCases(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        AliasMap aliasMap = new AliasMap(origSpec);
        this.danglingDataItemFixer = new DanglingDataItemTool(aliasMap);
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        if (layouts == null) {
            return origSpec;
        }
        NodeList styles = layouts.getElementsByTagName(ReportSpecification20._conditionalStyleCases);
        int nbStyles = styles.getLength();
        for (int i = nbStyles - 1; i > 0; --i) {
            Element style = (Element)styles.item(i);
            this.checkConditionalStyleCases(style, upgradeSession);
        }
        return origSpec;
    }

    private void checkConditionalStyleCases(Element conditionalStyleCases, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String refVar = conditionalStyleCases.getAttribute(ReportSpecification20._refVariable);
        Document doc = conditionalStyleCases.getOwnerDocument();
        Element variable = BeringVariables.getReportVariable(doc, refVar);
        if (variable == null) {
            throw new UpgradeException("Internal error -- _conditionalStyleCases referenced a non-existant variable.  This should have been fixed earlier.");
        }
        Element expressionElement = XmlUtils.getFirstChildElementByName(variable, ReportSpecification20._reportExpression);
        if (expressionElement == null) {
            throw new UpgradeException("Internal error -- _conditionalStyleCases referenced a variable with no expression.  This should have been fixed earlier.");
        }
        String expression = XmlUtils.getText(expressionElement);
        StringReader reader = new StringReader(expression);
        IExpression parseTree = null;
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            parseTree = parser.start();
        }
        catch (CrxParserException e) {
            throw new UpgradeException("Internal error -- _conditionalStyleCases referenced a variable that does not parse.  This should have been fixed earlier.");
        }
        if (parseTree == null) {
            throw new UpgradeException("Internal error -- _conditionalStyleCases referenced a variable that does not parse.  This should have been fixed earlier.");
        }
        Set<NameExpression> refDataItems = GetNames.getNames(parseTree);
        if (!refDataItems.isEmpty()) {
            for (NameExpression dataItem : refDataItems) {
                boolean fixed;
                if (!this.danglingDataItemFixer.isDangling(dataItem, conditionalStyleCases) || (fixed = this.danglingDataItemFixer.fix(dataItem, conditionalStyleCases, upgradeSession))) continue;
                this.removeConditionalStyle(conditionalStyleCases, dataItem.toString(this.expressionLocale), upgradeSession);
                return;
            }
        }
    }

    private void removeConditionalStyle(Element conditionalStyleCasesElement, String danglingDataItem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String variableName = conditionalStyleCasesElement.getAttribute(ReportSpecification20._refVariable);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CONDITIONALSTYLECASES_REMOVED_DANGLING_DATAITEM(variableName, danglingDataItem);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)conditionalStyleCasesElement, 1, message);
            Element conditionalStyles = (Element)conditionalStyleCasesElement.getParentNode();
            NodeList stylesList = XmlUtils.getChildElementsByName(conditionalStyles, ReportSpecification20._conditionalStyleCases);
            if (stylesList.getLength() > 1) {
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)conditionalStyleCasesElement, message);
            } else {
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)conditionalStyles, message);
            }
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }
}

