/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataFormatUpgrader
implements UpgradePipelineElement {
    public DataFormatUpgrader(IConfiguration config) throws UpgradeException {
    }

    @Override
    public Document upgrade(Document reportSpec, UpgradeSessionContext context) throws UpgradeException {
        if (reportSpec == null) {
            return reportSpec;
        }
        try {
            Element layouts = PathWalker.getC8LayoutsElement(reportSpec);
            if (layouts == null) {
                return reportSpec;
            }
            DataFormatExaminer examiner = new DataFormatExaminer();
            DomWalker.bottomUpWalkElements(layouts, examiner);
        }
        catch (XmlException ex) {
            UpgradeException.throwNestedException(ex);
        }
        return reportSpec;
    }

    private static class DataFormatExaminer
    implements DomWalker.Examiner {
        private DataFormatExaminer() {
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String name = XmlUtils.getName(elem);
            if (!name.equals(ReportSpecification20._dataFormat)) {
                return DomWalker.SearchOrder.proceed;
            }
            Element style = (Element)elem.getParentNode();
            if (style == null || !XmlUtils.getName(style).equals(ReportSpecification20._style)) {
                return DomWalker.SearchOrder.proceed;
            }
            Element textItem = (Element)style.getParentNode();
            if (textItem == null || !XmlUtils.getName(textItem).equals(ReportSpecification20._textItem)) {
                return DomWalker.SearchOrder.proceed;
            }
            Element contents = (Element)textItem.getParentNode();
            if (contents == null || !XmlUtils.getName(contents).equals(ReportSpecification20._contents)) {
                return DomWalker.SearchOrder.proceed;
            }
            Element container = XmlUtils.getParentElement(contents);
            if (container == null) {
                return DomWalker.SearchOrder.proceed;
            }
            String containerName = XmlUtils.getName(container);
            if (!ReportSpecification20._listColumnBody.equals(containerName)) {
                return DomWalker.SearchOrder.proceed;
            }
            NodeList contentsChildren = XmlUtils.getChildElements(contents);
            if (contentsChildren.getLength() != 1) {
                return DomWalker.SearchOrder.proceed;
            }
            Element containerStyle = XmlUtils.getFirstChildElementByName(container, ReportSpecification20._style);
            if (containerStyle != null) {
                Element containerDataFormat = XmlUtils.getFirstChildElementByName(containerStyle, ReportSpecification20._dataFormat);
                if (containerDataFormat != null) {
                    return DomWalker.SearchOrder.proceed;
                }
            } else {
                containerStyle = XmlUtils.createElement(container.getOwnerDocument(), ReportSpecification20._style);
                container.appendChild(containerStyle);
            }
            containerStyle.appendChild(elem);
            NodeList styleChildren = XmlUtils.getChildElements(style);
            if (styleChildren.getLength() == 0) {
                textItem.removeChild(style);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

