/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionList;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.FunctionExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.StringLiteralExpression;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticReportExpressions;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class FunctionReplacement {
    private Locale expressionLocale;

    public FunctionReplacement(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    public Document upgradeFunctions(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (v4Spec == null) {
            return v4Spec;
        }
        List<Element> expressions = BalticReportExpressions.getReportExpressions(v4Spec);
        if (expressions.isEmpty()) {
            return v4Spec;
        }
        Hashtable<FunctionExpression, FunctionExpression> replacements = new Hashtable<FunctionExpression, FunctionExpression>();
        ExpressionList parameters = new ExpressionList();
        StringLiteralExpression param1 = new StringLiteralExpression("'metadataModel'");
        parameters.add(param1);
        FunctionExpression oldFunction = new FunctionExpression("ReportOption", parameters);
        ExpressionList newParameters = new ExpressionList();
        FunctionExpression newFunction = new FunctionExpression("ModelPath", newParameters);
        replacements.put(oldFunction, newFunction);
        Element report = XmlUtils.getFirstChildElementByName(v4Spec, "report");
        if (report == null) {
            return v4Spec;
        }
        for (Element expression : expressions) {
            this.replace(expression, replacements, upgradeSession);
        }
        return v4Spec;
    }

    private void replace(Element expressionElement, Hashtable<FunctionExpression, FunctionExpression> replacements, UpgradeSessionContext upgradeSession) throws UpgradeException {
        IExpression parseTree;
        String expression = XmlUtils.getText(expressionElement);
        StringReader reader = new StringReader(expression);
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            parseTree = parser.start();
        }
        catch (CrxParserException ex) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CRX_PARSER_ERROR_2(expression, ex.getLocalizedMessage());
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)expressionElement, 0, message);
            return;
        }
        BooleanValue changed = new BooleanValue(false);
        parseTree = parseTree.replace(replacements, changed);
        if (changed.get()) {
            String newExpression = parseTree.toString(this.expressionLocale);
            XmlUtils.removeChildren(expressionElement);
            Document doc = expressionElement.getOwnerDocument();
            Text newExpressionTextNode = doc.createTextNode(newExpression);
            expressionElement.appendChild(newExpressionTextNode);
        }
    }
}

