/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InlineLayoutComponentReferences
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document beringReportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        if (beringReportSpec == null) {
            return beringReportSpec;
        }
        beringReportSpec.normalize();
        try {
            layouts = PathWalker.getC8LayoutsElement(beringReportSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        if (layouts == null) {
            return beringReportSpec;
        }
        HashSet<String> inProgress = new HashSet<String>();
        this.inline(layouts, layouts, inProgress, upgradeSession);
        XmlUtils.writeIntermediateDocument(beringReportSpec, "v5_layoutComponentRefsInlined", upgradeSession.getConfiguration());
        return beringReportSpec;
    }

    private void inline(Element elem, Element layouts, Set<String> inProgress, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (elem == null) {
            return;
        }
        String elemName = XmlUtils.getName(elem);
        if (!ReportSpecification20._layoutComponentRef.equals(elemName)) {
            this.inlineDescendants(elem, layouts, inProgress, upgradeSession);
        } else {
            String referencedElementName = elem.getAttribute(ReportSpecification20._refLayoutElement);
            if (inProgress.contains(referencedElementName)) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_RECURSIVE_LAYOUT_COMPONENT_REF(referencedElementName);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)elem, 0, message);
                return;
            }
            inProgress.add(referencedElementName);
            Element referencedElement = XmlUtils.getElementWithAttributeValue(layouts, ReportSpecification20._name, referencedElementName);
            this.inlineLayoutComponentRef(elem, referencedElement, referencedElementName, inProgress, layouts, upgradeSession);
            inProgress.remove(referencedElementName);
        }
    }

    private void inlineLayoutComponentRef(Element reference, Element referencedElement, String referencedElementName, Set<String> inProgress, Element layouts, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (referencedElement == null) {
            return;
        }
        Document doc = reference.getOwnerDocument();
        Element inlineNotice = XmlUtils.createElement(doc, "_inlinedLayoutComponentRef");
        inlineNotice.setAttribute(ReportSpecification20._refLayoutElement, referencedElementName);
        Element referencedElementCopy = (Element)referencedElement.cloneNode(true);
        inlineNotice.appendChild(referencedElementCopy);
        NodeList children = reference.getChildNodes();
        int nbChildren = children.getLength();
        if (nbChildren > 1) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INTERNAL_ERROR_LAYOUT_COMPONENT_REF_HAS_UNEXPECTED_CHILDREN(referencedElementName);
            upgradeSession.getUpgradeNotes().addUpgradeNote(reference, 0, message, true);
        } else if (nbChildren == 1) {
            Element overrides = XmlUtils.getFirstChildElementByName(reference, ReportSpecification20._layoutComponentOverrides);
            if (overrides == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INTERNAL_ERROR_LAYOUT_COMPONENT_REF_HAS_UNEXPECTED_CHILDREN(ReportSpecification20._layoutComponentOverrides);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)reference, 0, message);
            } else {
                this.inlineLayoutComponentOverrides(referencedElementName, referencedElementCopy, overrides, inProgress, layouts, upgradeSession);
            }
        }
        this.removeNames(referencedElementCopy);
        Element parent = XmlUtils.getParentElement(reference);
        parent.replaceChild(inlineNotice, reference);
        this.inline(referencedElementCopy, layouts, inProgress, upgradeSession);
    }

    private void removeNames(Element elem) {
        if (elem == null) {
            return;
        }
        String elemName = XmlUtils.getName(elem);
        if (elem.hasAttribute(ReportSpecification20._name) && !ReportSpecification20._XMLAttribute.equals(elemName)) {
            String name = elem.getAttribute(ReportSpecification20._name);
            elem.removeAttribute(ReportSpecification20._name);
            elem.setAttribute("_originalName", name);
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.removeNames(childElement);
        }
    }

    private void inlineLayoutComponentOverrides(String refElementName, Element refElementClone, Element overrides, Set<String> inProgress, Element layouts, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document doc = overrides.getOwnerDocument();
        for (Node child = overrides.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element overrideElement = (Element)child;
            String childName = XmlUtils.getName(overrideElement);
            if (!ReportSpecification20._layoutComponentOverride.equals(childName)) {
                String msg = upgradeSession.getTranslatedMessages().getString(RspecUpgradeMessage.RSU_SPC_INTERNAL_ERROR_UNEXPECTED_ELEMENT(childName));
                throw new UpgradeException(msg);
            }
            String refLayoutElementName = overrideElement.getAttribute(ReportSpecification20._refLayoutElement);
            Element refLayoutElement = XmlUtils.getElementWithAttributeValue(refElementClone, ReportSpecification20._name, refLayoutElementName);
            if (refLayoutElement == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_LAYOUT_COMPONENT_REF_OVERRIDE_NOT_FOUND(refElementName, refLayoutElementName);
                upgradeSession.getUpgradeNotes().addUpgradeNote(overrideElement, 2, message, true);
                continue;
            }
            Element inlineNotice = XmlUtils.createElement(doc, "_inlinedLayoutComponentOverride");
            inlineNotice.setAttribute(ReportSpecification20._refLayoutElement, refLayoutElementName);
            Node overrideBody = overrideElement.getFirstChild();
            while (overrideBody != null) {
                Node nextSibling = overrideBody.getNextSibling();
                inlineNotice.appendChild(overrideBody);
                overrideBody = nextSibling;
            }
            Element parent = XmlUtils.getParentElement(refLayoutElement);
            parent.replaceChild(inlineNotice, refLayoutElement);
        }
    }

    private void inlineDescendants(Element parent, Element layouts, Set<String> inProgress, UpgradeSessionContext context) throws UpgradeException {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.inline(childElement, layouts, inProgress, context);
        }
    }
}

