/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InvalidLayoutComponentReferenceRemover {
    public Document fix(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        LinkedList<Element> invalidReferences = new LinkedList<Element>();
        NodeList layoutComponentReferences = v5Spec.getElementsByTagName(ReportSpecification20._layoutComponentRef);
        int nbReferences = layoutComponentReferences.getLength();
        for (int referenceNb = 0; referenceNb < nbReferences; ++referenceNb) {
            Element layoutComponentRef = (Element)layoutComponentReferences.item(referenceNb);
            if (!layoutComponentRef.hasAttribute(ReportSpecification20._refLayoutElement)) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INVALID_LAYOUT_COMPONENT_REF_REMOVED("");
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutComponentRef, 1, message);
                invalidReferences.add(layoutComponentRef);
                continue;
            }
            String ref = layoutComponentRef.getAttribute(ReportSpecification20._refLayoutElement);
            if (ref.length() < 1) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INVALID_LAYOUT_COMPONENT_REF_REMOVED(ref);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutComponentRef, 1, message);
                invalidReferences.add(layoutComponentRef);
                continue;
            }
            Element referencedElement = XmlUtils.getElementWithAttributeValue(layoutComponentRef.getOwnerDocument(), ReportSpecification20._name, ref);
            if (referencedElement != null) continue;
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INVALID_LAYOUT_COMPONENT_REF_REMOVED(ref);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutComponentRef, 1, message);
            invalidReferences.add(layoutComponentRef);
        }
        for (Element layoutComponentRef : invalidReferences) {
            this.remove(layoutComponentRef, upgradeSession);
        }
        return v5Spec;
    }

    private void remove(Element elem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            RspecUpgradeMessage deletedMsg = RspecUpgradeMessage.RSU_SPC_XML_NODE_REMOVED_0();
            upgradeSession.getXmlCommentOutTool().commentOutNode((Node)elem, deletedMsg);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }
}

