/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParser;
import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.AndExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.EqualityExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParameterExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MasterDetailInfo {
    private long parameterId = 0L;
    private final String baltic = "http://developer.cognos.com/schemas/report/1/";
    private final String strMasterDetailInfo = "masterDetailInfo";
    private final String strMasterDetailLink = "masterDetailLink";
    private final String strDetailFilter = "detailFilter";
    private final String strMasterDetailData = "masterDetailData";
    private final String strMasterContext = "masterContext";
    private final String strDetailContext = "detailContext";
    private final String strDataItemContext = "dataItemContext";
    private final String strParameterContext = "parameterContext";
    private final String strFilterExpression = "filterExpression";
    private Locale expressionLocale;

    MasterDetailInfo(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    public Document getMasterDetailInfo(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document v5MasterDetail = null;
        try {
            v5MasterDetail = XmlUtils.createDocument();
        }
        catch (IOException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
        Element masterDetailInfo = v5MasterDetail.createElement(this.strMasterDetailInfo);
        v5MasterDetail.appendChild(masterDetailInfo);
        Element report = v4Spec.getDocumentElement();
        if (report == null) {
            return v4Spec;
        }
        Set<String> ignoredQueries = this.getIgnoredQueries(v4Spec);
        NodeList queries = report.getElementsByTagNameNS(this.baltic, "BIQuery");
        if (queries != null) {
            int nbQueries = queries.getLength();
            for (int queryNb = 0; queryNb < nbQueries; ++queryNb) {
                Element query = (Element)queries.item(queryNb);
                this.processQuery(masterDetailInfo, ignoredQueries, query, upgradeSession);
            }
        }
        return v5MasterDetail;
    }

    private void processQuery(Element masterDetailInfo, Set<String> ignoredQueries, Element masterQuery, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String masterName = masterQuery.getAttribute("name");
        NodeList detailQueries = masterQuery.getElementsByTagNameNS(this.baltic, "detailQuery");
        if (detailQueries == null) {
            return;
        }
        int nbDetailQueries = detailQueries.getLength();
        for (int detailQueryNb = 0; detailQueryNb < nbDetailQueries; ++detailQueryNb) {
            Element detailQuery = (Element)detailQueries.item(detailQueryNb);
            String detailName = detailQuery.getAttribute("refQuery");
            if (ignoredQueries.contains(detailName)) continue;
            this.createMasterDetailData(masterDetailInfo, masterName, detailQuery, upgradeSession);
        }
    }

    private void createMasterDetailData(Element masterDetailInfo, String masterName, Element detailQuery, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document v5MasterDetail = XmlUtils.getOwnerDoc(masterDetailInfo);
        String detailName = detailQuery.getAttribute("refQuery");
        Element detailData = v5MasterDetail.createElement(this.strMasterDetailData);
        masterDetailInfo.appendChild(detailData);
        detailData.setAttribute("masterQueryName", masterName);
        detailData.setAttribute("detailQueryName", detailName);
        this.addConditions(masterName, detailQuery, detailData, upgradeSession);
        this.addLinkParameters(masterName, detailQuery, detailData, upgradeSession);
    }

    private void addConditions(String masterName, Element detailQuery, Element detailData, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList conditions = detailQuery.getElementsByTagNameNS(this.baltic, "condition");
        if (conditions == null) {
            return;
        }
        int nbConditions = conditions.getLength();
        if (nbConditions <= 0) {
            return;
        }
        String detailName = detailQuery.getAttribute("refQuery");
        Hashtable<IExpression, IExpression> parameters = new Hashtable<IExpression, IExpression>();
        for (int conditionNb = 0; conditionNb < nbConditions; ++conditionNb) {
            Element condition = (Element)conditions.item(conditionNb);
            String conditionString = XmlUtils.getText(condition);
            this.processConditionText(masterName, detailName, conditionString, detailData, parameters, upgradeSession);
        }
        this.writeParameterContext(detailData, parameters);
    }

    private void addLinkParameters(String masterName, Element detailQuery, Element detailData, UpgradeSessionContext upgradeSession) {
        NodeList linkParameters = detailQuery.getElementsByTagNameNS(this.baltic, "linkParameter");
        if (linkParameters == null) {
            return;
        }
        int nbLinkParameters = linkParameters.getLength();
        if (nbLinkParameters <= 0) {
            return;
        }
        String detailName = detailQuery.getAttribute("refQuery");
        for (int parameterNb = 0; parameterNb < nbLinkParameters; ++parameterNb) {
            Element linkParameter = (Element)linkParameters.item(parameterNb);
            this.processLinkParameter(masterName, detailName, linkParameter, detailData, upgradeSession);
        }
    }

    private void normalizedMasterDetail(Element mdData, AndExpression normalized, String masterQueryName, String detailQueryName, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document doc = mdData.getOwnerDocument();
        Enumeration<IExpression> subExpressions = normalized.getSubExpressions();
        while (subExpressions.hasMoreElements()) {
            EqualityExpression eq = (EqualityExpression)subExpressions.nextElement();
            NameExpression lhs = (NameExpression)eq.getLhs();
            NameExpression rhs = (NameExpression)eq.getRhs();
            if (lhs.m_identifiers.size() != 2 || rhs.m_identifiers.size() != 2) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_WRONG_NB_IDENTIFIERS();
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)mdData, 0, message);
                return;
            }
            Element masterDetailLink = doc.createElement(this.strMasterDetailLink);
            mdData.appendChild(masterDetailLink);
            Element masterContext = doc.createElement(this.strMasterContext);
            masterDetailLink.appendChild(masterContext);
            String refDataItem = null;
            if (lhs.m_identifiers.get(0).equals(masterQueryName)) {
                refDataItem = lhs.m_identifiers.get(1);
            } else if (rhs.m_identifiers.get(0).equals(masterQueryName)) {
                refDataItem = rhs.m_identifiers.get(1);
            } else {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_NO_MASTER_QUERY();
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)mdData, 0, message);
                return;
            }
            Element dataItemContext = doc.createElement(this.strDataItemContext);
            masterContext.appendChild(dataItemContext);
            dataItemContext.setAttribute("refDataItem", refDataItem);
            Element detailContext = doc.createElement(this.strDetailContext);
            masterDetailLink.appendChild(detailContext);
            String lhsQueryName = lhs.getQueryName();
            String rhsQueryName = rhs.getQueryName();
            if (lhsQueryName.equals(detailQueryName)) {
                refDataItem = lhs.getDataItem();
            } else if (rhsQueryName.equals(detailQueryName)) {
                refDataItem = rhs.getDataItem();
            } else {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_NO_DETAIL_QUERY();
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)mdData, 0, message);
                return;
            }
            Element dataItemContext2 = doc.createElement(this.strDataItemContext);
            detailContext.appendChild(dataItemContext2);
            dataItemContext2.setAttribute("refDataItem", refDataItem);
        }
    }

    private AndExpression normalize(IExpression orig) {
        AndExpression and;
        if (orig instanceof AndExpression) {
            and = (AndExpression)orig;
        } else {
            and = new AndExpression();
            and.add(orig);
        }
        Enumeration<IExpression> subExpressions = and.getSubExpressions();
        while (subExpressions.hasMoreElements()) {
            IExpression expr = subExpressions.nextElement();
            if (!(expr instanceof EqualityExpression)) {
                return null;
            }
            EqualityExpression ex = (EqualityExpression)expr;
            IExpression lhs = ex.getLhs();
            IExpression rhs = ex.getRhs();
            if (lhs == null) {
                return null;
            }
            if (rhs == null) {
                return null;
            }
            if (!(lhs instanceof NameExpression)) {
                return null;
            }
            if (!(rhs instanceof NameExpression)) {
                return null;
            }
            NameExpression name_lhs = (NameExpression)lhs;
            NameExpression name_rhs = (NameExpression)rhs;
            if (name_lhs.m_identifiers.size() < 1) {
                return null;
            }
            if (name_rhs.m_identifiers.size() >= 1) continue;
            return null;
        }
        return and;
    }

    private void getParameterMap(IExpression expression, String masterQueryName, String detailQueryName, Hashtable<IExpression, IExpression> masterParameterMap) throws UpgradeException {
        Set<NameExpression> nameExpressions = null;
        try {
            nameExpressions = GetNames.getNames(expression);
        }
        catch (ParseTreeException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
        Object[] nameExpressionsArray = nameExpressions.toArray();
        Arrays.sort(nameExpressionsArray);
        for (int i = 0; i < nameExpressionsArray.length; ++i) {
            NameExpression nameExpression = (NameExpression)nameExpressionsArray[i];
            String query = nameExpression.getQueryName();
            if (!query.equals(masterQueryName) || masterParameterMap.containsKey(nameExpression)) continue;
            String paramName = this.getNextParameterName();
            ParameterExpression param = new ParameterExpression(paramName);
            masterParameterMap.put(nameExpression, param);
        }
    }

    private void dataItemNames(IExpression expression, Hashtable<IExpression, IExpression> parameterMap) {
        if (!parameterMap.containsKey(expression)) {
            if (expression instanceof NameExpression) {
                NameExpression name = (NameExpression)expression;
                String dataItemName = name.getDataItem();
                NameExpression dataItem = new NameExpression();
                dataItem.add(dataItemName);
                parameterMap.put(expression, dataItem);
            } else {
                Enumeration<IExpression> subExpressions = expression.getSubExpressions();
                while (subExpressions.hasMoreElements()) {
                    IExpression exp = subExpressions.nextElement();
                    this.dataItemNames(exp, parameterMap);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConditionText(String masterName, String detailName, String conditionString, Element mdData, Hashtable<IExpression, IExpression> parameters, UpgradeSessionContext upgradeSession) throws UpgradeException {
        block7: {
            try {
                Document doc = mdData.getOwnerDocument();
                StringReader inputReader = new StringReader(conditionString);
                CqeParser parser = new CqeParser(inputReader, this.expressionLocale);
                IExpression full = null;
                try {
                    full = parser.start();
                }
                catch (CqeParserException ex) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CQE_PARSER_ERROR_2(conditionString, ex.getLocalizedMessage());
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)mdData, 0, message);
                    return;
                }
                full = full.optimize();
                AndExpression normalized = this.normalize(full);
                if (null != normalized) {
                    this.normalizedMasterDetail(mdData, normalized, masterName, detailName, upgradeSession);
                    break block7;
                }
                this.getParameterMap(full, masterName, detailName, parameters);
                Hashtable dataItemReplacements = (Hashtable)parameters.clone();
                this.dataItemNames(full, dataItemReplacements);
                Element detailFilter = doc.createElement(this.strDetailFilter);
                detailFilter.setAttribute("use", "optional");
                mdData.appendChild(detailFilter);
                Element filterExpression = doc.createElement(this.strFilterExpression);
                detailFilter.appendChild(filterExpression);
                BooleanValue changed = new BooleanValue(false);
                full.replace(dataItemReplacements, changed);
                full = full.optimize();
                String filter = full.toString(this.expressionLocale);
                CDATASection expression = doc.createCDATASection(filter);
                filterExpression.appendChild(expression);
            }
            catch (Exception e) {
                UpgradeException.throwNestedException(e);
            }
        }
    }

    private void writeParameterContext(Element mdData, Hashtable<IExpression, IExpression> parameters) {
        int nbParameters = parameters.size();
        if (nbParameters <= 0) {
            return;
        }
        Document doc = mdData.getOwnerDocument();
        Object[] namesArray = parameters.keySet().toArray();
        Arrays.sort(namesArray);
        for (int i = 0; i < nbParameters; ++i) {
            NameExpression name = (NameExpression)namesArray[i];
            String masterDataItemName = name.getDataItem();
            ParameterExpression tle = (ParameterExpression)parameters.get(name);
            String parameter = tle.getStringValue();
            Element masterDetailLink = doc.createElement(this.strMasterDetailLink);
            mdData.appendChild(masterDetailLink);
            Element masterContext = doc.createElement("masterContext");
            masterDetailLink.appendChild(masterContext);
            Element dataItemContext = doc.createElement(this.strDataItemContext);
            masterContext.appendChild(dataItemContext);
            dataItemContext.setAttribute("refDataItem", masterDataItemName);
            Element detailContext = doc.createElement(this.strDetailContext);
            masterDetailLink.appendChild(detailContext);
            parameter = parameter.substring(1);
            parameter = parameter.substring(0, parameter.length() - 1);
            Element parameterContext = doc.createElement(this.strParameterContext);
            detailContext.appendChild(parameterContext);
            parameterContext.setAttribute("parameter", parameter);
        }
    }

    private void processLinkParameter(String masterName, String detailName, Element linkParameter, Element mdData, UpgradeSessionContext upgradeSession) {
        Document doc = mdData.getOwnerDocument();
        String masterRefDataItem = linkParameter.getAttribute("refItem");
        if (masterRefDataItem == null) {
            try {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_ERROR_REFITEM_NULL();
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)mdData, 0, message);
                return;
            }
            catch (Exception ex) {
                return;
            }
        }
        String parameter = linkParameter.getAttribute("parameter");
        if (parameter == null) {
            try {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_ERROR_PARAMETER_NULL();
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)mdData, 0, message);
                return;
            }
            catch (Exception ex) {
                return;
            }
        }
        Element masterDetailLink = doc.createElement(this.strMasterDetailLink);
        mdData.appendChild(masterDetailLink);
        Element masterContext = doc.createElement(this.strMasterContext);
        masterDetailLink.appendChild(masterContext);
        Element dataItemContext = doc.createElement(this.strDataItemContext);
        masterContext.appendChild(dataItemContext);
        dataItemContext.setAttribute("refDataItem", masterRefDataItem);
        Element detailContext = doc.createElement(this.strDetailContext);
        masterDetailLink.appendChild(detailContext);
        Element parameterContext = doc.createElement(this.strParameterContext);
        detailContext.appendChild(parameterContext);
        parameterContext.setAttribute("parameter", parameter);
    }

    private Set<String> getIgnoredQueries(Document v4Spec) {
        HashSet<String> result = new HashSet<String>();
        if (v4Spec == null) {
            return result;
        }
        Element report = XmlUtils.getFirstChildElementByName(v4Spec, "report");
        if (report == null) {
            return result;
        }
        Element ret = XmlUtils.getFirstChildElementByName(report, "ret");
        if (ret == null) {
            return result;
        }
        Element theMap = XmlUtils.getFirstChildElementByName(ret, "theMap");
        if (theMap == null) {
            return result;
        }
        NodeList queryMappings = theMap.getElementsByTagName("queryMap");
        if (queryMappings != null) {
            int nbMappings = queryMappings.getLength();
            for (int mappingNb = 0; mappingNb < nbMappings; ++mappingNb) {
                Element mapping = (Element)queryMappings.item(mappingNb);
                String ignored = mapping.getAttribute("ignored");
                result.add(ignored);
            }
        }
        return result;
    }

    private String getNextParameterName() {
        ++this.parameterId;
        String paramName = "?param___md___" + this.parameterId + "?";
        return paramName;
    }
}

