/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NestedSectionedQuery
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        Element layouts;
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        if (layouts == null) {
            return origSpec;
        }
        this.checkDescendants(null, null, layouts, null, null, context);
        return origSpec;
    }

    private void checkDescendants(Element outer, Element middle, Element inner, String outerRefQuery, String middleRefQuery, UpgradeSessionContext context) throws UpgradeException {
        String innerRefQuery;
        if (inner.hasAttribute(ReportSpecification20._refQuery) && !(innerRefQuery = inner.getAttribute(ReportSpecification20._refQuery)).equals(middleRefQuery)) {
            if (innerRefQuery.equals(outerRefQuery)) {
                this.fixupSectioning(outer, middle, inner, context);
            }
            outer = middle;
            middle = inner;
            outerRefQuery = middleRefQuery;
            middleRefQuery = innerRefQuery;
        }
        for (Node child = inner.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            inner = (Element)child;
            this.checkDescendants(outer, middle, inner, outerRefQuery, middleRefQuery, context);
        }
    }

    private void fixupSectioning(Element outer, Element middle, Element inner, UpgradeSessionContext context) throws UpgradeException {
        Element masterDetailLinks = XmlUtils.getFirstChildElementByName(middle, ReportSpecification20._masterDetailLinks);
        if (masterDetailLinks == null) {
            return;
        }
        Element currentMasterDetailElement = XmlUtils.getFirstChildElementByName(inner, ReportSpecification20._masterDetailLinks);
        if (currentMasterDetailElement != null) {
            return;
        }
        Document doc = XmlUtils.getOwnerDoc(inner);
        Element newMasterDetailLinks = doc.createElementNS(ReportSpecification20.targetNamespace, ReportSpecification20._masterDetailLinks);
        NodeList links = XmlUtils.getChildElementsByName(masterDetailLinks, ReportSpecification20._masterDetailLink);
        int nbLinks = links.getLength();
        for (int linkNb = 0; linkNb < nbLinks; ++linkNb) {
            Element link = (Element)links.item(linkNb);
            Element newLink = doc.createElementNS(ReportSpecification20.targetNamespace, ReportSpecification20._masterDetailLink);
            newMasterDetailLinks.appendChild(newLink);
            Element masterContext = XmlUtils.getFirstChildElementByName(link, ReportSpecification20._masterContext);
            Element newMasterContext = doc.createElementNS(ReportSpecification20.targetNamespace, ReportSpecification20._masterContext);
            newLink.appendChild(newMasterContext);
            Element detailContext = XmlUtils.getFirstChildElementByName(link, ReportSpecification20._detailContext);
            Element newDetailContext = doc.createElementNS(ReportSpecification20.targetNamespace, ReportSpecification20._detailContext);
            newLink.appendChild(newDetailContext);
            if (XmlUtils.getFirstChildElementByName(detailContext, ReportSpecification20._dataItemContext) != null) {
                XmlUtils.cloneChildren(newMasterContext, detailContext);
                XmlUtils.cloneChildren(newDetailContext, masterContext);
                inner.appendChild(newMasterDetailLinks);
                continue;
            }
            this.logSectioningNotImplemented(context, outer, middle, inner, detailContext);
        }
    }

    private void logSectioningNotImplemented(UpgradeSessionContext upgradeSession, Element outer, Element middle, Element inner, Element detailContext) throws UpgradeException {
        String outerType = XmlUtils.getName(outer);
        String outerRefQuery = outer.getAttribute(ReportSpecification20._refQuery);
        String outerName = outer.getAttribute(ReportSpecification20._name);
        String middleType = XmlUtils.getName(middle);
        String middleRefQuery = middle.getAttribute(ReportSpecification20._refQuery);
        String middleName = middle.getAttribute(ReportSpecification20._name);
        String innerType = XmlUtils.getName(inner);
        String innerRefQuery = inner.getAttribute(ReportSpecification20._refQuery);
        String innerName = inner.getAttribute(ReportSpecification20._name);
        Element parameterContext = XmlUtils.getFirstChildElementByName(detailContext, ReportSpecification20._parameterContext);
        String parameter = parameterContext.getAttribute(ReportSpecification20._parameter);
        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_SECTIONING_NOT_IMPLEMENTED_WITH_PARAMETERS(outerType, outerRefQuery, outerName, middleType, middleRefQuery, middleName, innerType, innerRefQuery, innerName, parameter);
        upgradeSession.getUpgradeNotes().addUpgradeNote(inner, 0, msg, true);
    }
}

