/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.FunctionExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IfExpressionCrx;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IsMissingExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IsNullExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.OrExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.StringLiteralExpression;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticReportExpressions;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ParamExpressionFixup
implements UpgradePipelineElement {
    private Locale expressionLocale;

    public ParamExpressionFixup(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    @Override
    public Document upgrade(Document doc, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (doc == null) {
            return doc;
        }
        List<Element> expressions = BalticReportExpressions.getReportExpressions(doc);
        for (Element expressionElement : expressions) {
            this.fixExpression(expressionElement, upgradeSession);
        }
        XmlUtils.writeIntermediateDocument(doc, "ParamExpressionFixup", upgradeSession.getConfiguration());
        return doc;
    }

    private void fixExpression(Element expressionElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String expressionText = XmlUtils.getText(expressionElement);
        StringReader reader = new StringReader(expressionText);
        IExpression parseTree = null;
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            parseTree = parser.start();
        }
        catch (CrxParserException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
        BooleanValue changed = new BooleanValue(false);
        parseTree = parseTree.optimize(changed);
        parseTree = (IExpression)this.replace(parseTree, changed, null);
        if (changed.get()) {
            parseTree = parseTree.optimize(changed);
            String newExpression = parseTree.toString(this.expressionLocale);
            XmlUtils.removeChildren(expressionElement);
            Document doc = expressionElement.getOwnerDocument();
            Text newExpressionTextNode = doc.createTextNode(newExpression);
            expressionElement.appendChild(newExpressionTextNode);
        }
    }

    private IExpressionFragment replace(IExpressionFragment expression, BooleanValue changed, IExpressionFragment parentExpression) throws UpgradeException {
        int nbSubExpressions = expression.getNbSubExpressions();
        for (int subExpressionNb = 0; subExpressionNb < nbSubExpressions; ++subExpressionNb) {
            IExpressionFragment subExpression = expression.getSubExpression(subExpressionNb);
            BooleanValue subExpressionChanged = new BooleanValue(false);
            IExpressionFragment newSubExpression = this.replace(subExpression, subExpressionChanged, expression);
            if (!subExpressionChanged.get()) continue;
            changed.set(true);
            expression.setSubExpression(subExpressionNb, newSubExpression);
        }
        if (ParamExpressionFixup.isParamFunction(expression) && (parentExpression == null || !(parentExpression instanceof IsMissingExpression) && !(parentExpression instanceof IsNullExpression))) {
            expression = this.newExpression((FunctionExpression)expression);
            changed.set(true);
        }
        return expression;
    }

    private static boolean isParamFunction(IExpressionFragment expression) {
        if (!(expression instanceof FunctionExpression)) {
            return false;
        }
        FunctionExpression function = (FunctionExpression)expression;
        String name = function.getName();
        if (name.compareToIgnoreCase("ParamDisplayValue") == 0) {
            return true;
        }
        return name.compareToIgnoreCase("ParamValue") == 0;
    }

    private IfExpressionCrx newExpression(FunctionExpression functionExpr) {
        IsMissingExpression isMissing = new IsMissingExpression(functionExpr);
        IsNullExpression isNull = new IsNullExpression(functionExpr);
        OrExpression orExpression = new OrExpression();
        orExpression.add(isMissing);
        orExpression.add(isNull);
        StringLiteralExpression emptyString = new StringLiteralExpression("''");
        IfExpressionCrx ifExpression = new IfExpressionCrx(orExpression, emptyString, functionExpr);
        return ifExpression;
    }
}

