/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParseException;
import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParserException;
import com.cognos.rspecupgrade.internal.expressionparser.cqe.ICqeParser;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class QueryExpressionParseCheck
implements UpgradePipelineElement {
    private Locale expressionLocale;

    public QueryExpressionParseCheck(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        if (origSpec == null) {
            return origSpec;
        }
        Element report = XmlUtils.getFirstChildElementByName(origSpec, "report");
        if (report == null) {
            return origSpec;
        }
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet == null) {
            return origSpec;
        }
        NodeList expressions = querySet.getElementsByTagNameNS("http://developer.cognos.com/schemas/report/1/", "expression");
        this.validate(expressions, context);
        expressions = querySet.getElementsByTagNameNS("http://developer.cognos.com/schemas/report/1/", "condition");
        this.validate(expressions, context);
        return origSpec;
    }

    private void validate(NodeList expressionList, UpgradeSessionContext context) throws UpgradeException {
        int nbExpressions = expressionList.getLength();
        for (int i = 0; i < nbExpressions; ++i) {
            Element expression = (Element)expressionList.item(i);
            this.validate(expression, context);
        }
    }

    private void logParserException(Element expression, CqeParserException exception, UpgradeSessionContext context) {
        String text = XmlUtils.getText(expression);
        Log log = context.getLog();
        String msg = log.error(RspecUpgradeMessage.RSU_UPG_CQE_PARSER_ERROR_2(text, exception.getLocalizedMessage()));
        XmlUtils.insertComment(expression, msg);
    }

    private void logParseException(Element expression, CqeParseException exception, UpgradeSessionContext context) {
        if (!exception.errorHasMacro()) {
            this.logParserException(expression, exception, context);
        } else {
            String text = XmlUtils.getText(expression);
            Log log = context.getLog();
            String msg = log.warning(RspecUpgradeMessage.RSU_SPC_CQE_PARSER_MACRO_PARSE_ERROR(text, exception.getLocalizedMessage()));
            XmlUtils.insertComment(expression, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(Element expression, UpgradeSessionContext context) throws UpgradeException {
        String text = XmlUtils.getText(expression);
        StringReader reader = new StringReader(text);
        ICqeParser parser = context.createCqeParser(reader, this.expressionLocale);
        try {
            parser.start();
        }
        catch (CqeParseException e) {
            this.logParseException(expression, e, context);
        }
        catch (CqeParserException e) {
            this.logParserException(expression, e, context);
        }
    }
}

