/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification30;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SingletonFixup
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document doc, UpgradeSessionContext context) throws UpgradeException {
        if (doc == null) {
            return doc;
        }
        Element report = XmlUtils.getFirstChildElementByName(doc, ReportSpecification30._report);
        if (report == null) {
            return doc;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification30._layouts);
        if (layouts == null) {
            return doc;
        }
        NodeList textItems = layouts.getElementsByTagName(ReportSpecification30._textItem);
        int nbTextItems = textItems.getLength();
        for (int i = 0; i < nbTextItems; ++i) {
            this.checkTextItem((Element)textItems.item(i), context);
        }
        return doc;
    }

    private void checkTextItem(Element textItem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (textItem.hasAttribute(ReportSpecification30._useDetailValue)) {
            return;
        }
        Element dataSource = XmlUtils.getFirstChildElementByName(textItem, ReportSpecification30._dataSource);
        if (dataSource == null) {
            return;
        }
        Element dataItemValue = XmlUtils.getFirstChildElementByName(dataSource, ReportSpecification30._dataItemValue);
        if (dataItemValue == null) {
            return;
        }
        BeringQueryFinder queryFinder = new BeringQueryFinder();
        String refDataItem = dataItemValue.getAttribute(ReportSpecification30._refDataItem);
        String queryName = queryFinder.findQueryName(dataItemValue, refDataItem);
        Element queryUser = BeringQueryFinder.findRefQueryElement(dataItemValue, queryName);
        if (queryUser == null) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_QUERY_NOT_FOUND_FOR_DATAITEM(refDataItem);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)dataItemValue, 0, message);
            return;
        }
        String queryUserName = XmlUtils.getName(queryUser);
        if (!queryUserName.equals(ReportSpecification30._page)) {
            return;
        }
        textItem.setAttribute(ReportSpecification30._useDetailValue, ReportSpecification30._true);
    }
}

