/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.textboxrangeparser.ParseException;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.textboxrangeparser.Range;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.textboxrangeparser.TextBoxRangeParserImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextBoxRangeDefaultSelections
implements UpgradePipelineElement {
    private UpgradeSessionContext upgradeSession;

    private Vector<Range> parseSelections(String defaultSelections) throws ParseException {
        StringReader reader = new StringReader(defaultSelections);
        TextBoxRangeParserImpl parser = new TextBoxRangeParserImpl(reader);
        return parser.start_ranges();
    }

    private void createDefaultRangeSelection(Element parent, Range range) {
        Element defaultRanges = XmlUtils.createChildElement(parent, ReportSpecification20._defaultRangeSelection);
        defaultRanges.setAttribute(ReportSpecification20._min, range.getMin());
        defaultRanges.setAttribute(ReportSpecification20._max, range.getMax());
    }

    private void changeSimpleSelection(Element defaultSimpleSelection) throws UpgradeException {
        Element parent = (Element)defaultSimpleSelection.getParentNode();
        XmlUtils.removeNodeFromParent(defaultSimpleSelection);
        String defaultSelections = XmlUtils.getText(defaultSimpleSelection);
        try {
            Vector<Range> ranges = this.parseSelections(defaultSelections);
            for (Range range : ranges) {
                this.createDefaultRangeSelection(parent, range);
            }
        }
        catch (ParseException e) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_RANGE_CANNOT_PARSE(defaultSelections);
            this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)defaultSimpleSelection, 0, msg);
        }
    }

    private void changeSimpleSelections(LinkedList<Node> selections) throws UpgradeException {
        for (Element element : selections) {
            this.changeSimpleSelection(element);
        }
    }

    private void changeSimpleSelections(NodeList defaultSimpleSelectionList) throws UpgradeException {
        int nbSelections = defaultSimpleSelectionList.getLength();
        LinkedList<Node> selections = new LinkedList<Node>();
        for (int i = 0; i < nbSelections; ++i) {
            selections.add(defaultSimpleSelectionList.item(i));
        }
        this.changeSimpleSelections(selections);
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        this.upgradeSession = upgradeSession;
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        RangeChanger examiner = new RangeChanger();
        try {
            DomWalker.topDownWalkElements(layouts, examiner);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }

    private class RangeChanger
    implements DomWalker.Examiner {
        private RangeChanger() {
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            if (!XmlUtils.getName(elem).equals(ReportSpecification20._textBox)) {
                return DomWalker.SearchOrder.proceed;
            }
            if (!elem.getAttribute(ReportSpecification20._range).equals(ReportSpecification20._true)) {
                return DomWalker.SearchOrder.proceed;
            }
            Element defaultSelections = XmlUtils.getFirstChildElementByName(elem, ReportSpecification20._defaultSelections);
            if (defaultSelections == null) {
                return DomWalker.SearchOrder.proceed;
            }
            NodeList defaultSimpleSelectionList = XmlUtils.getChildElementsByName(defaultSelections, ReportSpecification20._defaultSimpleSelection);
            try {
                TextBoxRangeDefaultSelections.this.changeSimpleSelections(defaultSimpleSelectionList);
            }
            catch (UpgradeException e) {
                XmlException.throwNestedException(e);
                throw new XmlException(e);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

