/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.NamespaceContext10x20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.IUpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnusedBrokenVariableRemover
implements UpgradePipelineElement {
    private boolean shouldVariableBeRemoved(Element variableDefinition, Document v5Spec, BeringQueryFinder queryFinder, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (upgradeSession.getUpgradeNotes().containsErrorMessages(variableDefinition)) {
            return true;
        }
        Element reportExpression = XmlUtils.getFirstChildElementByName(variableDefinition, ReportSpecification20._reportExpression);
        return upgradeSession.getUpgradeNotes().containsErrorMessages(reportExpression);
    }

    private void downgradeErrorsToWarnings(Element variableDefinition, UpgradeSessionContext upgradeSession) throws UpgradeException {
        IUpgradeNotes upgradeNotes = upgradeSession.getUpgradeNotes();
        upgradeNotes.downgradeErrorsToWarnings(variableDefinition);
        Element reportExpression = XmlUtils.getFirstChildElementByName(variableDefinition, ReportSpecification20._reportExpression);
        upgradeNotes.downgradeErrorsToWarnings(reportExpression);
    }

    private void removeUnusedVariable(Element variableDefinition, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.downgradeErrorsToWarnings(variableDefinition, upgradeSession);
        String name = variableDefinition.getAttribute(ReportSpecification20._name);
        RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_UNUSED_REPORTVARIABLE_REMOVED(name);
        upgradeSession.getUpgradeNotes().addUpgradeNote((Node)variableDefinition, 2, message);
        try {
            upgradeSession.getXmlCommentOutTool().commentOutNode((Node)variableDefinition, message);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    @Override
    public Document upgrade(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        BeringQueryFinder queryFinder = new BeringQueryFinder();
        LinkedList<Element> unusedVariables = this.findUnusedVariables(v5Spec);
        for (Element variableDefinition : unusedVariables) {
            boolean bRemoveVariable = this.shouldVariableBeRemoved(variableDefinition, v5Spec, queryFinder, upgradeSession);
            if (!bRemoveVariable) continue;
            this.removeUnusedVariable(variableDefinition, upgradeSession);
        }
        return v5Spec;
    }

    private LinkedList<Element> findUnusedVariables(Document v5Spec) throws UpgradeException {
        try {
            LinkedList<Element> unusedElements = new LinkedList<Element>();
            Set<String> usedNames = this.findUsedVariableNames(v5Spec);
            String definationPath = "/bering:report/bering:reportVariables/bering:reportVariable";
            NodeList reportVariablesList = XmlUtils.selectNodeList(v5Spec, definationPath, NamespaceContext10x20.instance);
            int nbNodes = reportVariablesList.getLength();
            for (int i = 0; i < nbNodes; ++i) {
                Element reportVariableElement = (Element)reportVariablesList.item(i);
                String name = reportVariableElement.getAttribute(ReportSpecification20._name);
                if (usedNames.contains(name) || unusedElements.contains(reportVariableElement)) continue;
                unusedElements.add(reportVariableElement);
            }
            return unusedElements;
        }
        catch (XPathExpressionException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private Set<String> findUsedVariableNames(Document v5Spec) throws UpgradeException {
        try {
            HashSet<String> variableNames = new HashSet<String>();
            String usagePath = "/bering:report/bering:layouts//@refVariable";
            NodeList reportVariablesList = XmlUtils.selectNodeList(v5Spec, usagePath, NamespaceContext10x20.instance);
            int nbNodes = reportVariablesList.getLength();
            for (int i = 0; i < nbNodes; ++i) {
                Attr attr = (Attr)reportVariablesList.item(i);
                String varName = attr.getValue();
                variableNames.add(varName);
            }
            return variableNames;
        }
        catch (XPathExpressionException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }
}

