/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BeringVariables;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.ExpressionQueryFixer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class VariableDemultiplexer {
    private Map<String, Element> variables;
    private Map<String, String> originalExpressions;
    private Element reportVariablesElement;
    private Locale expressionLocale;

    public VariableDemultiplexer(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
        this.originalExpressions = null;
    }

    public Document demultiplexVariables(Document v20Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element reportElement = XmlUtils.getFirstChildElementByName(v20Spec, ReportSpecification20._report);
        if (reportElement == null) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_ELEMENT_NOT_FOUND(ReportSpecification20._report);
            Element root = XmlUtils.getRoot(v20Spec);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)root, 0, message);
            return null;
        }
        this.reportVariablesElement = XmlUtils.getFirstChildElementByName(reportElement, ReportSpecification20._reportVariables);
        if (this.reportVariablesElement == null) {
            return v20Spec;
        }
        NodeList reportVariablesNodeList = XmlUtils.getChildElementsByName(this.reportVariablesElement, ReportSpecification20._reportVariable);
        if (reportVariablesNodeList == null) {
            return v20Spec;
        }
        int nbVariables = reportVariablesNodeList.getLength();
        if (nbVariables == 0) {
            return v20Spec;
        }
        this.variables = new HashMap<String, Element>();
        for (int variableNb = 0; variableNb < nbVariables; ++variableNb) {
            Element variable = (Element)reportVariablesNodeList.item(variableNb);
            this.normalizeVariableExpression(variable, upgradeSession);
            String variableName = variable.getAttribute(ReportSpecification20._name);
            this.variables.put(variableName, variable);
        }
        this.originalExpressions = new HashMap<String, String>();
        Element layoutsElement = XmlUtils.getFirstChildElementByName(reportElement, ReportSpecification20._layouts);
        this.demultiplexVariables(layoutsElement, upgradeSession);
        return v20Spec;
    }

    private void demultiplexVariables(Element layoutElement, UpgradeSessionContext context) throws UpgradeException {
        if (layoutElement == null) {
            return;
        }
        if (layoutElement.hasAttribute(ReportSpecification20._refVariable)) {
            this.setNewVariableName(layoutElement, context);
        }
        for (Node child = layoutElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.demultiplexVariables(childElement, context);
        }
    }

    private void normalizeVariableExpression(Element variable, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document v20Spec = variable.getOwnerDocument();
        Element expressionElement = XmlUtils.getFirstChildElementByName(variable, ReportSpecification20._reportExpression);
        if (expressionElement != null) {
            String expression = XmlUtils.getText(expressionElement);
            StringReader reader = new StringReader(expression);
            IExpression parseTree = null;
            try {
                CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
                parseTree = parser.start();
            }
            catch (CrxParserException e) {
                UpgradeException.throwNestedException(e);
            }
            if (parseTree != null) {
                Node child;
                BooleanValue changed = new BooleanValue(false);
                parseTree = parseTree.optimize(changed);
                expression = parseTree.toString(this.expressionLocale);
                do {
                    if ((child = expressionElement.getFirstChild()) == null) continue;
                    expressionElement.removeChild(child);
                } while (child != null);
                Text expressionText = v20Spec.createTextNode(expression);
                expressionElement.appendChild(expressionText);
            }
        }
    }

    private String getQualifiedExpression(Element layoutElement, String originalExpressionText, UpgradeSessionContext upgradeSession) throws UpgradeException {
        StringReader reader = new StringReader(originalExpressionText);
        IExpression parseTree = null;
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            parseTree = parser.start();
            if (parseTree == null) {
                return originalExpressionText;
            }
        }
        catch (CrxParserException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
        parseTree = parseTree.optimize();
        BeringQueryFinder queryFinder = new BeringQueryFinder();
        ExpressionQueryFixer queryFixer = new ExpressionQueryFixer();
        parseTree = queryFixer.fixQueries(parseTree, layoutElement, queryFinder, originalExpressionText, true, upgradeSession);
        return parseTree.toString(this.expressionLocale);
    }

    private void setNewVariableName(Element variableUser, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String oldVariableName = variableUser.getAttribute("refVariable");
        if (!this.variables.containsKey(oldVariableName)) {
            return;
        }
        Element originalVariableDefinition = this.variables.get(oldVariableName);
        Element originalExpressionElement = XmlUtils.getFirstChildElementByName(originalVariableDefinition, ReportSpecification20._reportExpression);
        String originalExpressionText = null;
        boolean createNewVariable = false;
        if (this.originalExpressions.containsKey(oldVariableName)) {
            originalExpressionText = this.originalExpressions.get(oldVariableName);
            createNewVariable = true;
        } else {
            originalExpressionText = XmlUtils.getText(originalExpressionElement);
            createNewVariable = false;
        }
        String newExpressionString = this.getQualifiedExpression(variableUser, originalExpressionText, upgradeSession);
        if (newExpressionString.equals(originalExpressionText)) {
            createNewVariable = false;
        }
        if (createNewVariable) {
            Element newVariableDefinition = BeringVariables.cloneVariable(originalVariableDefinition);
            Element newExpression = XmlUtils.getFirstChildElementByName(newVariableDefinition, ReportSpecification20._reportExpression);
            XmlUtils.removeChildren(newExpression);
            Document doc = newExpression.getOwnerDocument();
            Text newExpressionTextNode = doc.createTextNode(newExpressionString);
            newExpression.appendChild(newExpressionTextNode);
            String newName = BeringVariables.findExistingVariable(newVariableDefinition, upgradeSession);
            if (newName == null) {
                newName = newVariableDefinition.getAttribute(ReportSpecification20._name);
                this.reportVariablesElement.appendChild(newVariableDefinition);
                this.variables.put(newName, newVariableDefinition);
            }
            variableUser.setAttribute("refVariable", newName);
        } else {
            XmlUtils.removeChildren(originalExpressionElement);
            Document doc = originalExpressionElement.getOwnerDocument();
            Text newExpressionTextNode = doc.createTextNode(newExpressionString);
            originalExpressionElement.appendChild(newExpressionTextNode);
            this.originalExpressions.put(oldVariableName, originalExpressionText);
        }
    }
}

