/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._110to120;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification110;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RemoveJoinMethod
implements UpgradePipelineElement {
    private Document removeJoinMethod(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException, XmlException {
        if (reportSpec == null) {
            throw new UpgradeInternalErrorException("reportSpec document should not be null.");
        }
        Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification110._report);
        Element queries = null;
        NodeList queryList = null;
        Element query = null;
        NodeList applyFilterJoinList = null;
        if (report != null && (queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification110._queries)) != null && (queryList = queries.getElementsByTagName(ReportSpecification110._query)) != null) {
            for (int i = 0; i < queryList.getLength(); ++i) {
                query = (Element)queryList.item(i);
                if (query == null || (applyFilterJoinList = query.getElementsByTagName(ReportSpecification110._applyFilterJoin)) == null) continue;
                for (int j = 0; j < applyFilterJoinList.getLength(); ++j) {
                    Element applyFilterJoin = (Element)applyFilterJoinList.item(j);
                    if (!applyFilterJoin.hasAttribute(ReportSpecification110._joinMethod)) continue;
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DEPRECATED_ATTRIBUTE_REMOVED(ReportSpecification110._joinMethod);
                    try {
                        upgradeSession.getUpgradeNotes().addUpgradeNote(applyFilterJoin, 2, msg, true);
                    }
                    catch (UpgradeException e) {
                        XmlException.throwNestedException(e);
                    }
                    try {
                        applyFilterJoin.removeAttribute(ReportSpecification110._joinMethod);
                        continue;
                    }
                    catch (DOMException e) {
                        UpgradeException.throwNestedException(e);
                    }
                }
            }
        }
        return reportSpec;
    }

    @Override
    public Document upgrade(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.removeJoinMethod(reportSpec, upgradeSession);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return reportSpec;
    }
}

