/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._110to120;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification110;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification120;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.LinkedList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class vizPropertyValuesTypeChange
implements UpgradePipelineElement {
    private Document upgradeVizPropertyValueTypes(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException, XmlException {
        block10: {
            if (reportSpec == null) {
                throw new UpgradeInternalErrorException("reportSpec document should not be null.");
            }
            try {
                Node parent;
                NodeList vizPropertyValuesList;
                Element layouts;
                Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification110._report);
                if (report == null || (layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification110._layouts)) == null || (vizPropertyValuesList = layouts.getElementsByTagName(ReportSpecification110._vizPropertyValues)) == null) break block10;
                LinkedList<Element> elementsToBeRemoved = new LinkedList<Element>();
                for (int i = 0; i < vizPropertyValuesList.getLength(); ++i) {
                    Element vizPropertyValues = (Element)vizPropertyValuesList.item(i);
                    if (vizPropertyValues == null) continue;
                    parent = XmlUtils.getAncestorElement(vizPropertyValues);
                    String parentName = parent.getNodeName();
                    if (parentName.equals(ReportSpecification110._vizCategoryField) || parentName.equals(ReportSpecification110._vizValue)) {
                        elementsToBeRemoved.add(vizPropertyValues);
                        continue;
                    }
                    NodeList vizPropertyValueList = vizPropertyValues.getElementsByTagName(ReportSpecification110._vizPropertyValue);
                    if (vizPropertyValueList == null) continue;
                    boolean bSucceed = true;
                    for (int j = 0; j < vizPropertyValueList.getLength(); ++j) {
                        Element vizPropertyValue = (Element)vizPropertyValueList.item(j);
                        bSucceed &= this.replaceVizPropertyValueWithNewType(reportSpec, vizPropertyValue, upgradeSession);
                    }
                    if (!bSucceed) continue;
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_VIZ_VIZPROPERTYVALUE_UPGRADED_TO_NEWTYPES();
                    String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
                    Element commentAnchor = vizPropertyValues;
                    if (vizPropertyValueList.getLength() > 0) {
                        commentAnchor = (Element)vizPropertyValueList.item(0);
                    }
                    XmlUtils.insertComment(commentAnchor, translatedMessage);
                }
                for (Element e : elementsToBeRemoved) {
                    parent = e.getParentNode();
                    Node nodeRemoved = parent.removeChild(e);
                    if (nodeRemoved == null) continue;
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_VIZ_VIZPROPERTYVALUES_NOLONGER_ASCHILD();
                    String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
                    try {
                        upgradeSession.getUpgradeNotes().addUpgradeNote(parent, 2, msg);
                    }
                    catch (UpgradeException exception) {
                        XmlException.throwNestedException(exception);
                    }
                    XmlUtils.insertComment(parent, translatedMessage);
                }
            }
            catch (DOMException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        return reportSpec;
    }

    private boolean replaceVizPropertyValueWithNewType(Document doc, Element vizPropertyValue, UpgradeSessionContext upgradeSession) throws XmlException {
        Node valueNode;
        String name = vizPropertyValue.getAttribute(ReportSpecification110._name);
        if (name.equals("animationEffect")) {
            doc.renameNode(vizPropertyValue, vizPropertyValue.getNamespaceURI(), ReportSpecification120._vizPropertyEnumValue);
        } else if ((name.equals("width") || name.equals("height")) && (valueNode = vizPropertyValue.getFirstChild()) != null) {
            String value = valueNode.getTextContent();
            if (value != null && value.endsWith("px")) {
                String newValue = value.substring(0, value.lastIndexOf("px"));
                valueNode.setNodeValue(newValue);
            }
            doc.renameNode(vizPropertyValue, vizPropertyValue.getNamespaceURI(), ReportSpecification120._vizPropertyIntegerValue);
        }
        return true;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.upgradeVizPropertyValueTypes(origSpec, upgradeSession);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }
}

