/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._13xto140;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification131;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification140;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NumericPatternEncoding
implements UpgradePipelineElement {
    private static final List<String> numericFormats = new ArrayList<String>();
    private static final List<String> supportedLanguages;
    private char decimal;
    private char group;

    private String fixPattern(String pattern) {
        StringBuilder builder = new StringBuilder(pattern.length());
        for (int index = 0; index < pattern.length(); ++index) {
            char c = pattern.charAt(index);
            if (c == '.') {
                builder.append(this.decimal);
                continue;
            }
            if (c == ',') {
                builder.append(this.group);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private void convertPatterns(Element layouts) {
        Element numericalFormat;
        Document doc = XmlUtils.getOwnerDoc(layouts);
        DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
        NodeIterator numericalFormats = traversal.createNodeIterator(layouts, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node node) {
                return numericFormats.contains(node.getLocalName()) ? (short)1 : 3;
            }
        }, false);
        while ((numericalFormat = (Element)numericalFormats.nextNode()) != null) {
            String whenNegative;
            if (numericalFormat == null) continue;
            String pattern = numericalFormat.getAttribute(ReportSpecification131._pattern);
            if (pattern != null && !pattern.isEmpty()) {
                numericalFormat.setAttribute(ReportSpecification140._pattern, this.fixPattern(pattern));
            }
            if ((whenNegative = numericalFormat.getAttribute(ReportSpecification131._whenNegative)) == null || whenNegative.isEmpty()) continue;
            numericalFormat.setAttribute(ReportSpecification140._whenNegative, this.fixPattern(whenNegative));
        }
    }

    private void updateNumericPatterns(Document reportSpec) throws UpgradeException, XmlException {
        if (reportSpec == null) {
            throw new UpgradeInternalErrorException("reportSpec document should not be null.");
        }
        Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification131._report);
        if (report == null) {
            return;
        }
        String expressionLocaleAttr = report.getAttribute(ReportSpecification131._expressionLocale);
        if (expressionLocaleAttr == null || expressionLocaleAttr.isEmpty()) {
            throw new UpgradeInternalErrorException("expressionLocale attribute is required.");
        }
        Locale expressionLocale = Locale.forLanguageTag(expressionLocaleAttr);
        if (supportedLanguages.contains(expressionLocale.getLanguage())) {
            return;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification131._layouts);
        if (layouts == null) {
            return;
        }
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance((Locale)expressionLocale);
        this.decimal = symbols.getDecimalSeparator();
        this.group = symbols.getGroupingSeparator();
        this.convertPatterns(layouts);
    }

    @Override
    public Document upgrade(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.updateNumericPatterns(reportSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return reportSpec;
    }

    static {
        numericFormats.add(ReportSpecification131._numberFormat);
        numericFormats.add(ReportSpecification131._currencyFormat);
        numericFormats.add(ReportSpecification131._percentFormat);
        numericFormats.add(ReportSpecification131._intervalFormat);
        numericFormats.add(ReportSpecification131._format);
        supportedLanguages = new ArrayList<String>();
        supportedLanguages.add("fr");
        supportedLanguages.add("de");
        supportedLanguages.add("da");
        supportedLanguages.add("pt");
        supportedLanguages.add("en");
    }
}

