/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._20to30;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification30;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeringChartUpgrader
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document v5Doc, UpgradeSessionContext context) throws UpgradeException {
        Element layoutsElement;
        try {
            layoutsElement = PathWalker.getC8LayoutsElement(v5Doc);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        if (layoutsElement == null) {
            return v5Doc;
        }
        NodeList chartElements = layoutsElement.getElementsByTagName(ReportSpecification20._threeDCombinationChart);
        int nbNodes = chartElements.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Element chartElement = (Element)chartElements.item(i);
            this.upgradeChartAxis(v5Doc, chartElement, ReportSpecification20._ordinalAxisX);
            this.upgradeChartAxis(v5Doc, chartElement, ReportSpecification20._ordinalAxisY);
            this.upgradeChartAxis(v5Doc, chartElement, ReportSpecification20._numericalAxis);
        }
        return v5Doc;
    }

    public void upgradeChartAxis(Document v5Doc, Element chart, String strAxisName) {
        Element axisElement = XmlUtils.getFirstChildElementByName(chart, strAxisName);
        if (axisElement == null) {
            return;
        }
        Element gridElement = XmlUtils.findOrAddChildElement(axisElement, ReportSpecification30.targetNamespace, ReportSpecification20._gridlines);
        XmlUtils.addAttributeIfMissing(gridElement, ReportSpecification30._color, "#000000");
        XmlUtils.addAttributeIfMissing(gridElement, ReportSpecification30._weight, "0");
        XmlUtils.addAttributeIfMissing(gridElement, ReportSpecification30._lineStyle, "solid");
        Element axisLineElement = XmlUtils.findOrAddChildElement(axisElement, ReportSpecification30.targetNamespace, ReportSpecification20._axisLine);
        XmlUtils.addAttributeIfMissing(axisLineElement, ReportSpecification30._color, "black");
    }
}

