/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._30to40;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListColumnRowSpanRemover
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        if (origSpec == null) {
            return origSpec;
        }
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        if (layouts == null) {
            return origSpec;
        }
        NodeList lists = layouts.getElementsByTagNameNS(ReportSpecification40.targetNamespace, ReportSpecification40._list);
        int nbLists = lists.getLength();
        for (int listNb = 0; listNb < nbLists; ++listNb) {
            Element list = (Element)lists.item(listNb);
            HashSet<String> groupNames = new HashSet<String>();
            Element listGroups = XmlUtils.getFirstChildElementByName(list, ReportSpecification40._listGroups);
            if (listGroups != null) {
                NodeList listGroupList = listGroups.getElementsByTagNameNS(ReportSpecification40.targetNamespace, ReportSpecification40._listGroup);
                int nbListGroups = listGroupList.getLength();
                for (int listGroupNb = 0; listGroupNb < nbListGroups; ++listGroupNb) {
                    Element listGroup = (Element)listGroupList.item(listGroupNb);
                    String dataItem = listGroup.getAttribute(ReportSpecification40._refDataItem);
                    groupNames.add(dataItem);
                }
            }
            SpanFinder finder = new SpanFinder(groupNames, list, upgradeSession);
            try {
                DomWalker.topDownWalkElements(list, finder);
                continue;
            }
            catch (XmlException ex) {
                UpgradeException.throwNestedException(ex);
            }
        }
        return origSpec;
    }

    static class SpanFinder
    implements DomWalker.Examiner {
        private Element listElement;
        private Set<String> groupNames;
        private UpgradeSessionContext upgradeSession;

        public SpanFinder(Set<String> groupNames, Element list, UpgradeSessionContext upgradeSession) {
            this.groupNames = groupNames;
            this.listElement = list;
            this.upgradeSession = upgradeSession;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String dataItem;
            String name = XmlUtils.getName(elem);
            if (name.equals(ReportSpecification40._listColumnRowSpan) && !this.groupNames.contains(dataItem = elem.getAttribute(ReportSpecification40._refDataItem))) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_LIST_COLUMN_ROW_SPAN_NOT_GROUPED(dataItem);
                try {
                    this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)elem, 1, message);
                }
                catch (UpgradeException e) {
                    throw new XmlException(e);
                }
                this.upgradeSession.getXmlCommentOutTool().commentOutNode((Node)elem, message);
                return DomWalker.SearchOrder.siblingsOnly;
            }
            if (elem != this.listElement && elem.hasAttribute(ReportSpecification40._refQuery)) {
                return DomWalker.SearchOrder.siblingsOnly;
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

