/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._30to40;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification30;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveAllowIsMissingAttribute
implements UpgradePipelineElement {
    private Element getLayoutsElement(Document reportSpec) {
        if (reportSpec == null) {
            return null;
        }
        Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification40._report);
        if (report == null) {
            return null;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification40._layouts);
        return layouts;
    }

    @Override
    public Document upgrade(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Element layouts = this.getLayoutsElement(reportSpec);
            if (layouts == null) {
                return reportSpec;
            }
            AllowIsMissingRemovalExaminer examiner = new AllowIsMissingRemovalExaminer(upgradeSession);
            DomWalker.bottomUpWalkElements(layouts, examiner);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return reportSpec;
    }

    private static class AllowIsMissingRemovalExaminer
    implements DomWalker.Examiner {
        private UpgradeSessionContext upgradeSession;

        public AllowIsMissingRemovalExaminer(UpgradeSessionContext upgradeSession) {
            this.upgradeSession = upgradeSession;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            if (elem.hasAttribute(ReportSpecification30._allowIsMissing)) {
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_BLARING_ALLOWISMISSING_REMOVED();
                try {
                    this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)elem, 2, msg);
                }
                catch (UpgradeException e) {
                    XmlException.throwNestedException(e);
                }
                String translatedMessage = this.upgradeSession.getTranslatedMessages().getString(msg);
                XmlUtils.insertComment(elem, translatedMessage);
                elem.removeAttribute(ReportSpecification30._allowIsMissing);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

