/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._30to40;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification30;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlAttributeRenderToOutput
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Element layouts;
            try {
                layouts = PathWalker.getC8LayoutsElement(origSpec);
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
                throw new UpgradeInternalErrorException();
            }
            if (layouts == null) {
                return origSpec;
            }
            XmlAttributeRenderExaminer examiner = new XmlAttributeRenderExaminer(upgradeSession);
            DomWalker.bottomUpWalkElements(layouts, examiner);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }

    class XmlAttributeRenderExaminer
    implements DomWalker.Examiner {
        private UpgradeSessionContext upgradeSession;

        public XmlAttributeRenderExaminer(UpgradeSessionContext upgradeSession) throws UpgradeException {
            this.upgradeSession = upgradeSession;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String localName = XmlUtils.getName(elem);
            if (localName.equals(ReportSpecification40._XMLAttribute) && elem.hasAttribute(ReportSpecification30._render)) {
                if (elem.hasAttribute(ReportSpecification40._output)) {
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_BLARING_XMLATTRIBUTE_HAS_RENDER_AND_OUTPUT();
                    try {
                        this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)elem, 2, msg);
                    }
                    catch (UpgradeException e) {
                        XmlException.throwNestedException(e);
                    }
                    String translatedMessage = this.upgradeSession.getTranslatedMessages().getString(msg);
                    XmlUtils.insertComment(elem, translatedMessage);
                } else {
                    String renderValue = elem.getAttribute(ReportSpecification30._render);
                    if (renderValue.equals(ReportSpecification30._true)) {
                        elem.setAttribute(ReportSpecification40._output, ReportSpecification40._XML);
                    } else {
                        elem.setAttribute(ReportSpecification40._output, ReportSpecification40._no);
                    }
                }
                elem.removeAttribute(ReportSpecification30._render);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

