/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.internal.xml.css.CssDeclaration;
import com.cognos.rspecupgrade.internal.xml.css.CssDeclarations;
import com.cognos.rspecupgrade.internal.xml.css.CssExpression;
import com.cognos.rspecupgrade.internal.xml.css.CssParser;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification70;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BackgroundImageFromCss
implements UpgradePipelineElement {
    private CssParser cssParser;

    private String getUrl(CssExpression propertyValue) {
        String startToken = "url(";
        String value = propertyValue.toString();
        int start = value.indexOf("url(");
        int end = value.lastIndexOf(")");
        String url = value.substring(start + "url(".length(), end);
        return url.trim();
    }

    private String getAutomaticPositionAttribute(CssExpression positionExpression) throws UpgradeException {
        String horizontal = null;
        String vertical = null;
        if (positionExpression.size() != 2) {
            throw new UpgradeException("Need two terms for background-position");
        }
        String horizontalTerm = positionExpression.get(0);
        String verticalTerm = positionExpression.get(1);
        if (horizontalTerm.equals("left")) {
            horizontal = "left";
        } else if (horizontalTerm.equals("center")) {
            horizontal = "center";
        } else if (horizontalTerm.equals("right")) {
            horizontal = "right";
        } else {
            throw new UpgradeException("term was not recognized: " + horizontalTerm);
        }
        if (verticalTerm.equals("top")) {
            vertical = "Top";
        } else if (verticalTerm.equals("center")) {
            vertical = "Middle";
        } else if (verticalTerm.equals("bottom")) {
            vertical = "Bottom";
        } else {
            throw new UpgradeException("term was not recognized: " + verticalTerm);
        }
        String position = horizontal + vertical;
        return position;
    }

    private void createAutomaticPosition(Element backgroundImagePosition, CssDeclaration position) throws UpgradeException {
        Element automaticPosition = XmlUtils.createChildElement(backgroundImagePosition, ReportSpecification70._automaticPosition);
        CssExpression expression = position.getPropertyValue();
        String positionValue = this.getAutomaticPositionAttribute(expression);
        automaticPosition.setAttribute(ReportSpecification70._automaticPosition, positionValue);
    }

    private void setBackgroundPosition(Element backgroundImage, CssDeclarations declarations) throws UpgradeException {
        Element backgroundImagePosition = XmlUtils.createChildElement(backgroundImage, ReportSpecification70._backgroundImagePosition);
        CssDeclaration position = declarations.get("background-position");
        if (position != null) {
            this.createAutomaticPosition(backgroundImagePosition, position);
            declarations.remove(position);
        } else {
            XmlUtils.createChildElement(backgroundImagePosition, ReportSpecification70._stretchPosition);
        }
    }

    private void fixCssElement(Element css) throws UpgradeException {
        try {
            String value = css.getAttribute(ReportSpecification70._value);
            CssDeclarations declarations = this.cssParser.parseDeclarationList(value);
            CssDeclaration declaration = declarations.get("background-image");
            if (declaration == null) {
                return;
            }
            declarations.remove(declaration);
            Element style = XmlUtils.getParentElement(css);
            Element generatedBackground = XmlUtils.getOrCreateChildElementByName(style, ReportSpecification70._generatedBackground);
            Element backgroundImages = XmlUtils.getOrCreateChildElementByName(generatedBackground, ReportSpecification70._backgroundImages);
            Element backgroundImage = XmlUtils.createChildElement(backgroundImages, ReportSpecification70._backgroundImage);
            String url = this.getUrl(declaration.getPropertyValue());
            backgroundImage.setAttribute(ReportSpecification70._URL, url);
            this.setBackgroundPosition(backgroundImage, declarations);
            String newStyle = declarations.toString();
            css.setAttribute(ReportSpecification70._value, newStyle);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private void fixCssElements(LinkedList<Element> cssList) throws UpgradeException {
        for (Element css : cssList) {
            this.fixCssElement(css);
        }
    }

    private void fixCssElements(NodeList cssList) throws UpgradeException {
        LinkedList<Element> cssCopy = new LinkedList<Element>();
        for (int i = 0; i < cssList.getLength(); ++i) {
            Element css = (Element)cssList.item(i);
            cssCopy.addLast(css);
        }
        this.fixCssElements(cssCopy);
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        this.cssParser = upgradeSession.getCssParser();
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        NodeList cssList = layouts.getElementsByTagName(ReportSpecification70._CSS);
        this.fixCssElements(cssList);
        return origSpec;
    }
}

