/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification60;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.IUpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CrosstabFactCellClassMovedToStyle
implements UpgradePipelineElement {
    private void replaceDefaultStyle(Element factCell, Element defaultStyle, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String refStyle = factCell.getAttribute(ReportSpecification60._class);
        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_CLASS_ATTRIBUTE_MOVED_TO_EXISTING_DEFAULT_STYLE(XmlUtils.getName(factCell), defaultStyle.getAttribute(ReportSpecification60._refStyle), refStyle);
        IUpgradeNotes upgradeNotes = upgradeSession.getUpgradeNotes();
        upgradeNotes.addUpgradeNote((Node)defaultStyle, 1, msg);
        defaultStyle.setAttribute(ReportSpecification60._refStyle, refStyle);
    }

    private void replaceDefaultStyles(Element factCell, NodeList defaultStyleList, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int nbStyles = defaultStyleList.getLength();
        for (int i = 0; i < nbStyles; ++i) {
            this.replaceDefaultStyle(factCell, (Element)defaultStyleList.item(i), upgradeSession);
        }
    }

    private void createDefaultStyle(Element factCell, Element defaultStyles) {
        String refStyle = factCell.getAttribute(ReportSpecification60._class);
        Element defaultStyle = XmlUtils.createChildElement(defaultStyles, ReportSpecification60._defaultStyle);
        defaultStyle.setAttribute(ReportSpecification60._refStyle, refStyle);
    }

    private void moveClass(Element factCell, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element style = XmlUtils.getOrCreateChildElementByName(factCell, ReportSpecification40._style);
        Element defaultStyles = XmlUtils.getOrCreateChildElementByName(style, ReportSpecification40._defaultStyles);
        NodeList defaultStyleList = XmlUtils.getChildElementsByName(defaultStyles, ReportSpecification60._defaultStyle);
        if (defaultStyleList.getLength() != 0) {
            this.replaceDefaultStyles(factCell, defaultStyleList, upgradeSession);
        } else {
            this.createDefaultStyle(factCell, defaultStyles);
        }
    }

    private void lookForConflictingApplySingleDefaultStyle(Element factCell, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (!factCell.hasAttribute(ReportSpecification60._applySingleDefaultStyle)) {
            return;
        }
        String existingValue = factCell.getAttribute(ReportSpecification60._applySingleDefaultStyle);
        if (ReportSpecification60._true.equals(existingValue)) {
            return;
        }
        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_APPLYSINGLEDEFAULTSTYLE_OVERRIDDEN();
        IUpgradeNotes upgradeNotes = upgradeSession.getUpgradeNotes();
        upgradeNotes.addUpgradeNote((Node)factCell, 0, msg);
    }

    private void setApplySingleDefaultStyle(Element factCell, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.lookForConflictingApplySingleDefaultStyle(factCell, upgradeSession);
        factCell.setAttribute(ReportSpecification60._applySingleDefaultStyle, ReportSpecification60._true);
    }

    private void fixFactCell(Element factCell, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.setApplySingleDefaultStyle(factCell, upgradeSession);
        this.moveClass(factCell, upgradeSession);
        factCell.removeAttribute(ReportSpecification60._class);
    }

    private void checkFactCell(Element factCell, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (factCell.hasAttribute(ReportSpecification60._class)) {
            this.fixFactCell(factCell, upgradeSession);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
        NodeList factCells = layouts.getElementsByTagName(ReportSpecification60._crosstabFactCell);
        int nbFactCells = factCells.getLength();
        for (int i = 0; i < nbFactCells; ++i) {
            Element factCell = (Element)factCells.item(i);
            this.checkFactCell(factCell, upgradeSession);
        }
        return origSpec;
    }
}

