/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.internal.xml.css.CssDeclaration;
import com.cognos.rspecupgrade.internal.xml.css.CssDeclarations;
import com.cognos.rspecupgrade.internal.xml.css.CssExpression;
import com.cognos.rspecupgrade.internal.xml.css.CssParser;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification70;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CssStyleVerifier
implements UpgradePipelineElement {
    private void replaceCssStyle(Element css, CssDeclarations declarations) throws UpgradeException {
        String value = declarations.toString();
        css.setAttribute(ReportSpecification70._value, value);
    }

    private void logParseError(Element css, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String oldValue = css.getAttribute(ReportSpecification70._value);
        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_CSS_DECLARATION_BAD_PARSE(oldValue);
        Attr valueAttr = css.getAttributeNode(ReportSpecification70._value);
        upgradeSession.getUpgradeNotes().addUpgradeNote((Node)valueAttr, 0, msg);
    }

    private boolean isVerticalPosition(String term) {
        if (term.equals("top")) {
            return true;
        }
        if (term.equals("center")) {
            return true;
        }
        return term.equals("bottom");
    }

    private boolean isHorizontalPosition(String term) {
        if (term.equals("left")) {
            return true;
        }
        if (term.equals("center")) {
            return true;
        }
        return term.equals("right");
    }

    private void removeDeclarationDueToParseError(CssDeclaration declaration, CssDeclarations declarations, Element css, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.logParseError(css, upgradeSession);
        declarations.remove(declaration);
    }

    private void verifyBackgroundPositionWithOneTerm(CssDeclaration declaration, CssDeclarations declarations, Element css, UpgradeSessionContext upgradeSession) throws UpgradeException {
        CssExpression propertyValue = declaration.getPropertyValue();
        String term = propertyValue.get(0);
        if (this.isHorizontalPosition(term)) {
            propertyValue.add("center");
        } else if (this.isVerticalPosition(term)) {
            propertyValue.insert(0, "center");
        } else {
            this.removeDeclarationDueToParseError(declaration, declarations, css, upgradeSession);
        }
    }

    private void verifyBackgroundPositionWithTwoTerms(CssDeclaration declaration, CssDeclarations declarations, Element css, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String term1 = declaration.getPropertyValue().get(0);
        String term2 = declaration.getPropertyValue().get(1);
        if (!this.isHorizontalPosition(term1) || !this.isVerticalPosition(term2)) {
            this.removeDeclarationDueToParseError(declaration, declarations, css, upgradeSession);
        }
    }

    private void verifyBackgroundPosition(CssDeclaration declaration, CssDeclarations declarations, Element css, UpgradeSessionContext upgradeSession) throws UpgradeException {
        CssExpression expression = declaration.getPropertyValue();
        if (expression.size() == 1) {
            this.verifyBackgroundPositionWithOneTerm(declaration, declarations, css, upgradeSession);
        } else if (expression.size() == 2) {
            this.verifyBackgroundPositionWithTwoTerms(declaration, declarations, css, upgradeSession);
        } else {
            this.removeDeclarationDueToParseError(declaration, declarations, css, upgradeSession);
            return;
        }
    }

    private void verifyDeclaration(CssDeclaration declaration, CssDeclarations declarations, Element css, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String name = declaration.getPropertyName();
        if (name.equals("background-position")) {
            this.verifyBackgroundPosition(declaration, declarations, css, upgradeSession);
        }
    }

    private void verifyDeclarations(Element css, CssDeclarations declarations, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int nbDeclarations = declarations.size();
        for (int i = 0; i < nbDeclarations; ++i) {
            CssDeclaration declaration = declarations.get(i);
            this.verifyDeclaration(declaration, declarations, css, upgradeSession);
        }
    }

    private void verifyCssStyle(Element css, UpgradeSessionContext upgradeSession) throws UpgradeException {
        CssDeclarations declarations;
        String value = css.getAttribute(ReportSpecification70._value);
        CssParser cssParser = upgradeSession.getCssParser();
        try {
            declarations = cssParser.parseDeclarationList(value);
        }
        catch (XmlException e) {
            this.logParseError(css, upgradeSession);
            declarations = new CssDeclarations();
        }
        this.verifyDeclarations(css, declarations, upgradeSession);
        this.replaceCssStyle(css, declarations);
    }

    private void verifyCssStyles(NodeList cssList, UpgradeSessionContext upgradeSession) throws UpgradeException {
        for (int i = 0; i < cssList.getLength(); ++i) {
            Element css = (Element)cssList.item(i);
            this.verifyCssStyle(css, upgradeSession);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        NodeList cssList = layouts.getElementsByTagName(ReportSpecification70._CSS);
        this.verifyCssStyles(cssList, upgradeSession);
        return origSpec;
    }
}

