/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutTool;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RemoveNonSemanticAttribute
implements UpgradePipelineElement {
    private UpgradeSessionContext upgradeSessionContext;
    private String attributeName;
    private String[] removalLocation;

    RemoveNonSemanticAttribute(String attributeToRemove, String[] searchPath) throws UpgradeInternalErrorException {
        if (searchPath == null) {
            throw new UpgradeInternalErrorException("searchPath may not be null");
        }
        if (searchPath.length <= 0) {
            throw new UpgradeInternalErrorException("searchPath may not be empty");
        }
        this.attributeName = attributeToRemove;
        this.removalLocation = searchPath;
    }

    private Element getStartingLocation(Document reportSpecification) {
        Node searchLocation = reportSpecification;
        for (int i = 0; i < this.removalLocation.length && (searchLocation = XmlUtils.getFirstChildElementByName(searchLocation, this.removalLocation[i])) != null; ++i) {
        }
        return (Element)searchLocation;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.upgradeSessionContext = upgradeSession;
        Element searchLocation = this.getStartingLocation(origSpec);
        if (searchLocation != null) {
            try {
                DomWalker.topDownWalkElements(searchLocation, new Remover());
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        return origSpec;
    }

    private class Remover
    implements DomWalker.Examiner {
        private Remover() {
        }

        private MessageTemplate logDiagnostic(Attr attr) throws UpgradeException {
            String attributeName = XmlUtils.getName(attr);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NON_SEMANTIC_ATTRIBUTE_REMOVED(attributeName);
            RemoveNonSemanticAttribute.this.upgradeSessionContext.getUpgradeNotes().addUpgradeNote((Node)attr, 2, message);
            return message;
        }

        private void removeAttribute(Attr attr) throws XmlException, UpgradeException {
            MessageTemplate message = this.logDiagnostic(attr);
            XmlCommentOutTool tool = RemoveNonSemanticAttribute.this.upgradeSessionContext.getXmlCommentOutTool();
            tool.commentOutNode((Node)attr, message);
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            Attr attr = elem.getAttributeNode(RemoveNonSemanticAttribute.this.attributeName);
            if (attr != null) {
                try {
                    this.removeAttribute(attr);
                }
                catch (UpgradeException e) {
                    XmlException.throwNestedException(e);
                }
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

