/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutTool;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RemoveNonSemanticElement
implements UpgradePipelineElement {
    private UpgradeSessionContext upgradeSessionContext;
    private String elementName;
    private String[] removalLocation;

    RemoveNonSemanticElement(String elementToRemove, String[] searchPath) throws UpgradeInternalErrorException {
        if (searchPath == null) {
            throw new UpgradeInternalErrorException("searchPath may not be null");
        }
        if (searchPath.length <= 0) {
            throw new UpgradeInternalErrorException("searchPath may not be empty");
        }
        this.elementName = elementToRemove;
        this.removalLocation = searchPath;
    }

    private Element getStartingLocation(Document reportSpecification) {
        Node searchLocation = reportSpecification;
        for (int i = 0; i < this.removalLocation.length && (searchLocation = XmlUtils.getFirstChildElementByName(searchLocation, this.removalLocation[i])) != null; ++i) {
        }
        return (Element)searchLocation;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.upgradeSessionContext = upgradeSession;
        Element searchLocation = this.getStartingLocation(origSpec);
        if (searchLocation != null) {
            try {
                DomWalker.topDownWalkElements(searchLocation, new Remover());
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        return origSpec;
    }

    private class Remover
    implements DomWalker.Examiner {
        private Remover() {
        }

        private MessageTemplate logDiagnostic(Element elem) throws UpgradeException {
            String elementName = XmlUtils.getName(elem);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NON_SEMANTIC_ELEMENT_REMOVED(elementName);
            RemoveNonSemanticElement.this.upgradeSessionContext.getUpgradeNotes().addUpgradeNote((Node)elem, 2, message);
            return message;
        }

        private void removeElement(Element elem) throws XmlException, UpgradeException {
            MessageTemplate message = this.logDiagnostic(elem);
            XmlCommentOutTool tool = RemoveNonSemanticElement.this.upgradeSessionContext.getXmlCommentOutTool();
            tool.commentOutNode((Node)elem, message);
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String elemName = XmlUtils.getName(elem);
            if (elemName.equals(RemoveNonSemanticElement.this.elementName)) {
                try {
                    this.removeElement(elem);
                }
                catch (UpgradeException e) {
                    XmlException.throwNestedException(e);
                }
                return DomWalker.SearchOrder.siblingsOnly;
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

