/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification60;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveParetoCumulationAxisAttributes
implements UpgradePipelineElement {
    private UpgradeSessionContext upgradeSession;

    private void removeAttribute(Attr attr) throws XmlException {
        String attrName = XmlUtils.getName(attr);
        RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NON_SEMANTIC_ATTRIBUTE_REMOVED(attrName);
        try {
            this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)attr, 2, message);
        }
        catch (UpgradeException e) {
            XmlException.throwNestedException(e);
        }
        this.upgradeSession.getXmlCommentOutTool().commentOutNode((Node)attr, message);
    }

    private void removeAttribute(Element elem, String attributeName) throws XmlException {
        Attr attr = elem.getAttributeNode(attributeName);
        if (attr != null) {
            this.removeAttribute(attr);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSessionContext) throws UpgradeException {
        Element layouts;
        this.upgradeSession = upgradeSessionContext;
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        try {
            DomWalker.topDownWalkElements(layouts, new Examiner());
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }

    private class Examiner
    implements DomWalker.Examiner {
        private Examiner() {
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String name = XmlUtils.getName(elem);
            if (name.equals(ReportSpecification60._cumulationAxis)) {
                RemoveParetoCumulationAxisAttributes.this.removeAttribute(elem, ReportSpecification60._min);
                RemoveParetoCumulationAxisAttributes.this.removeAttribute(elem, ReportSpecification60._max);
                RemoveParetoCumulationAxisAttributes.this.removeAttribute(elem, ReportSpecification60._sameRangeAllInstances);
                RemoveParetoCumulationAxisAttributes.this.removeAttribute(elem, ReportSpecification60._scale);
                RemoveParetoCumulationAxisAttributes.this.removeAttribute(elem, ReportSpecification60._includeZeroForAutoScale);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

