/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._90to100;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification90;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoveCognosStatistics
implements UpgradePipelineElement {
    private void replaceElementWithImageElement(Document doc, Element customContent, UpgradeSessionContext upgradeSession) throws XmlException {
        Element imageNode = XmlUtils.createElement(doc, ReportSpecification90._image);
        Element dataSource = XmlUtils.createChildElement(imageNode, ReportSpecification90._dataSource);
        Element staticValue = XmlUtils.createChildElement(dataSource, ReportSpecification90._staticValue);
        XmlUtils.setText(staticValue, "../common/images/deprecatedstats.gif");
        Element alternateText = XmlUtils.createChildElement(imageNode, ReportSpecification90._alternateText);
        Element defaultText = XmlUtils.createChildElement(alternateText, ReportSpecification90._defaultText);
        RspecUpgradeMessage msgAltText = RspecUpgradeMessage.RSU_SPC_COGNOS_STATS_DEPRECATED_ALTTEXT();
        String translatedAltText = upgradeSession.getTranslatedMessages().getString(msgAltText);
        XmlUtils.setText(defaultText, translatedAltText);
        Element parent = XmlUtils.getAncestorElement(customContent);
        parent.removeChild(customContent);
        parent.appendChild(imageNode);
        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_COGNOS_STATS_DEPRECATED();
        String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
        try {
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)imageNode, 2, msg);
        }
        catch (UpgradeException e) {
            XmlException.throwNestedException(e);
        }
        XmlUtils.insertComment(imageNode, translatedMessage);
    }

    private Document replaceCustomContent(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException, XmlException {
        Element layouts;
        if (reportSpec == null) {
            throw new UpgradeInternalErrorException("reportSpec document should not be null.");
        }
        Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification90._report);
        if (report != null && (layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification90._layouts)) != null) {
            NodeList customContents = null;
            while ((customContents = layouts.getElementsByTagName(ReportSpecification90._customContent)) != null && customContents.getLength() > 0) {
                Element customContent = (Element)customContents.item(0);
                if (customContent == null || !customContent.getAttribute(ReportSpecification90._plugin).equals("cognos_stats")) continue;
                this.replaceElementWithImageElement(reportSpec, customContent, upgradeSession);
            }
            XmlUtils.writeIntermediateDocument(reportSpec, "RemoveCognosStatistics", upgradeSession.getConfiguration());
        }
        return reportSpec;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.replaceCustomContent(origSpec, upgradeSession);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }
}

