/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._90to100;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification90;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveRevisionAttribute
implements UpgradePipelineElement {
    private Document revisionRemoval(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException, XmlException {
        block6: {
            if (reportSpec == null) {
                throw new UpgradeInternalErrorException("reportSpec document should not be null.");
            }
            try {
                Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification90._report);
                if (report == null) {
                    throw new UpgradeInternalErrorException("Document does not have report as root.");
                }
                if (!report.hasAttribute(ReportSpecification90._revision)) break block6;
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DEPRECATED_ATTRIBUTE_REMOVED(ReportSpecification90._revision);
                try {
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)report, 2, msg);
                }
                catch (UpgradeException e) {
                    XmlException.throwNestedException(e);
                }
                String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
                XmlUtils.insertComment(report, translatedMessage);
                report.removeAttribute(ReportSpecification90._revision);
            }
            catch (DOMException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        return reportSpec;
    }

    @Override
    public Document upgrade(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.revisionRemoval(reportSpec, upgradeSession);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return reportSpec;
    }
}

