/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PostProcessingCleanup
implements UpgradePipelineElement {
    void moveComments(final Element destination, Element source) throws XmlException {
        final Node parent = destination.getParentNode();
        DomWalker.topDownWalkElements(source, new DomWalker.Examiner(){

            @Override
            public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                Node child = elem.getFirstChild();
                while (child != null) {
                    Node nextChild = child.getNextSibling();
                    if (child instanceof Comment) {
                        parent.insertBefore(child, destination);
                    }
                    child = nextChild;
                }
                return DomWalker.SearchOrder.proceed;
            }
        });
    }

    void deleteElement(Element elem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.moveComments(elem, elem);
            upgradeSession.getXmlDeleteTool().deleteNode(elem);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    void cleanLists(Document doc, final String listType, final String itemType, final UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Element root = XmlUtils.getRoot(doc);
            DomWalker.topDownWalkElements(root, new DomWalker.Examiner(){

                @Override
                public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                    NodeList items;
                    String name = XmlUtils.getName(elem);
                    if (listType.equals(name) && (items = elem.getElementsByTagName(itemType)).getLength() == 0) {
                        try {
                            PostProcessingCleanup.this.deleteElement(elem, upgradeSession);
                        }
                        catch (UpgradeException e) {
                            XmlException.throwNestedException(e);
                        }
                    }
                    return DomWalker.SearchOrder.proceed;
                }
            });
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    void cleanPropertyLists(Document doc, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.cleanLists(doc, ReportSpecification50._propertyList, ReportSpecification50._propertyItem, upgradeSession);
    }

    void cleanSortLists(Document doc, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.cleanLists(doc, ReportSpecification50._sortList, ReportSpecification50._sortItem, upgradeSession);
    }

    void cleanReportVariables(Document doc, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.cleanLists(doc, ReportSpecification50._reportVariables, ReportSpecification50._reportVariable, upgradeSession);
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.cleanPropertyLists(origSpec, upgradeSession);
        this.cleanSortLists(origSpec, upgradeSession);
        this.cleanReportVariables(origSpec, upgradeSession);
        return origSpec;
    }
}

