/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProblemsDetectedMessage
implements UpgradePipelineElement {
    private Element getUpgradeMessagesElement(Document doc) {
        Element report = XmlUtils.getFirstChildElementByName(doc, ReportSpecification50._report);
        if (report == null) {
            return null;
        }
        Element upgradeInfo = XmlUtils.getFirstChildElementByName(report, ReportSpecification50._upgradeInfo);
        if (upgradeInfo == null) {
            return null;
        }
        Element upgradeMessages = XmlUtils.getFirstChildElementByName(upgradeInfo, ReportSpecification50._upgradeMessages);
        return upgradeMessages;
    }

    private boolean hasErrorOrWarning(Element upgradeMessages) {
        NodeList upgradeMessageList = XmlUtils.getChildElementsByName(upgradeMessages, ReportSpecification50._upgradeMessage);
        for (int i = 0; i < upgradeMessageList.getLength(); ++i) {
            Element upgradeMessage = (Element)upgradeMessageList.item(i);
            String type = upgradeMessage.getAttribute(ReportSpecification50._type);
            if (ReportSpecification50._error.equals(type)) {
                return true;
            }
            if (!ReportSpecification50._warning.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element upgradeMessages = this.getUpgradeMessagesElement(origSpec);
        if (upgradeMessages != null && this.hasErrorOrWarning(upgradeMessages)) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INFO_VALIDATE_REPORT();
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)origSpec, 2, message);
        }
        return origSpec;
    }
}

