/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.expressionrewriter;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.BeringAugmented;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.expressionrewriter.ExpressionRewriterFramework;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.ExpressionLocale;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportExpressionRewriter
extends ExpressionRewriterFramework
implements UpgradePipelineElement {
    private Messages messages;

    public ReportExpressionRewriter(Messages messages) {
        this.messages = messages;
    }

    private Document rewriteReportExpressions(Document v5Spec, Locale locale, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element variables;
        Element report = XmlUtils.getRoot(v5Spec);
        if (report == null) {
            return null;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, BeringAugmented._layouts);
        if (layouts != null) {
            NodeList expressions = layouts.getElementsByTagName(BeringAugmented._reportExpression);
            this.rewriteExpressions(expressions, locale, upgradeSession);
        }
        if ((variables = XmlUtils.getFirstChildElementByName(report, BeringAugmented._reportVariables)) != null) {
            NodeList expressions = variables.getElementsByTagName(BeringAugmented._reportExpression);
            this.rewriteExpressions(expressions, locale, upgradeSession);
        }
        return v5Spec;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Locale expressionLocale = ExpressionLocale.getExpressionLocale(origSpec, upgradeSession);
        this.rewriteReportExpressions(origSpec, expressionLocale, upgradeSession);
        return origSpec;
    }

    private void rewriteExpressions(NodeList expressions, Locale locale, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int nbExpressions = expressions.getLength();
        for (int expressionNb = 0; expressionNb < nbExpressions; ++expressionNb) {
            Element expression = (Element)expressions.item(expressionNb);
            String oldExpression = XmlUtils.getText(expression);
            String newExpression = this.rewriteExpression(oldExpression, locale, expression, upgradeSession);
            XmlUtils.setText(expression, newExpression);
        }
    }

    @Override
    protected IExpression parse(String expression, Locale locale) {
        IExpression expressionTree;
        try {
            CrxParser parser = new CrxParser(new StringReader(expression), locale, this.messages);
            expressionTree = parser.start();
        }
        catch (Throwable ex) {
            expressionTree = null;
        }
        return expressionTree;
    }
}

