/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.format;

import com.cognos.i18n.ToolkitResources;
import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification30;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification60;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification70;
import java.io.File;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class LocalizedPatternChars {
    private IConfiguration config = null;
    private Messages messages = null;
    private String reportSpecNamespace = null;
    private String patternsFilePath = null;
    private Hashtable<String, String> patterns = null;

    public LocalizedPatternChars(IConfiguration theConfig, Messages theMessages, String theReportSpecNamespace) throws UpgradeException {
        this.config = theConfig;
        this.messages = theMessages;
        this.reportSpecNamespace = theReportSpecNamespace;
        this.loadPatterns();
    }

    public String getPatternCharsForLocale(String localeString) throws UpgradeException {
        String normalizedLocaleString = ToolkitResources.normalizeLocaleIdentifier((String)localeString);
        boolean languageOnly = ToolkitResources.isLocaleLanguageOnly((String)normalizedLocaleString);
        if (languageOnly) {
            normalizedLocaleString = this.getDefaultLocale(normalizedLocaleString);
        }
        if (!this.patterns.containsKey(normalizedLocaleString) && !this.patterns.containsKey(normalizedLocaleString = ToolkitResources.getLocaleLanguage((String)normalizedLocaleString))) {
            normalizedLocaleString = "en";
        }
        return this.patterns.get(normalizedLocaleString);
    }

    private void loadPatterns() throws UpgradeException {
        Document patternsDoc = this.loadPatternsDocument();
        this.loadPatternsTable(patternsDoc);
    }

    private Document loadPatternsDocument() throws UpgradeException {
        String fileName = null;
        if (this.reportSpecNamespace.equals("http://developer.cognos.com/schemas/report/1/")) {
            fileName = "I18NLocalizedFormatPatternChars_8_0.xml";
        } else if (this.reportSpecNamespace.equals(ReportSpecification20.targetNamespace)) {
            fileName = "I18NLocalizedFormatPatternChars_8_1.xml";
        } else if (this.reportSpecNamespace.equals(ReportSpecification30.targetNamespace)) {
            fileName = "I18NLocalizedFormatPatternChars_8_2.xml";
        } else if (this.reportSpecNamespace.equals(ReportSpecification40.targetNamespace) || this.reportSpecNamespace.equals(ReportSpecification50.targetNamespace) || this.reportSpecNamespace.equals(ReportSpecification60.targetNamespace) || this.reportSpecNamespace.equals(ReportSpecification70.targetNamespace)) {
            fileName = "I18NLocalizedFormatPatternChars_8_3.xml";
        } else {
            String msg = this.messages.getString(RspecUpgradeMessage.RSU_UPG_INVALID_REPORT_SPEC());
            throw new UpgradeInternalErrorException(msg);
        }
        File binDirFile = this.config.getBinDir();
        File patternFile = new File(binDirFile, fileName);
        this.patternsFilePath = patternFile.getAbsolutePath();
        try {
            Document patternDoc = XmlUtils.readDocument(patternFile);
            return patternDoc;
        }
        catch (IOException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private void loadPatternsTable(Document patternsDoc) throws UpgradeException {
        Element rootElem = XmlUtils.getRoot(patternsDoc);
        if (rootElem == null) {
            String msg = this.messages.getString(RspecUpgradeMessage.RSU_UPG_LOCALIZED_FORMAT_PATTERNS_FILE_INVALID(this.patternsFilePath));
            throw new UpgradeException(msg);
        }
        this.patterns = new Hashtable();
        Element localeId = XmlUtils.getFirstChildElementByName(rootElem, "localeId");
        while (localeId != null) {
            String localeName = localeId.getAttribute("name");
            Element localizedPatternElem = XmlUtils.getFirstChildElementByName(localeId, "localizedpattern");
            String patternString = localizedPatternElem.getAttribute("name");
            this.patterns.put(localeName, patternString);
            localeId = XmlUtils.getNextSiblingElement(localeId);
        }
    }

    private String getDefaultLocale(String languageCode) {
        return ToolkitResources.getDefaultLocaleForCurrentLocale((String)languageCode);
    }
}

