/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Message;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.AddMessages;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddUpgradePerformedComment
implements UpgradePipelineElement {
    private String sourceVersion;
    private String destinationVersion;

    public AddUpgradePerformedComment(String source, String destination) {
        this.sourceVersion = source;
        this.destinationVersion = destination;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element root;
        long currentTime = upgradeSession.getConfiguration().getCurrentTimeGenerator().getCurrentTime();
        TimeZone theTimeZone = upgradeSession.getConfiguration().getCurrentTimeGenerator().getTimeZone();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(theTimeZone);
        cal.setTimeInMillis(currentTime);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String msgText = upgradeSession.getTranslatedMessages().getString(RspecUpgradeMessage.RSU_SPC_INFO_UPGRADE_PERFORMED(this.sourceVersion, this.destinationVersion, Integer.toString(year), Integer.toString(month), Integer.toString(day), Integer.toString(hour), Integer.toString(minute), Integer.toString(second)));
        if (upgradeSession.getConfiguration().getUpgradeInfoMessage()) {
            Message msg = new Message(msgText, 2);
            origSpec = AddMessages.addMessage(origSpec, msg, upgradeSession.getTranslatedMessages().getLocale());
            XmlUtils.writeIntermediateDocument(origSpec, "after_upgrade_message", upgradeSession.getConfiguration());
        }
        if ((root = XmlUtils.getRoot(origSpec)) != null) {
            Comment comment = origSpec.createComment(msgText);
            Node firstChild = root.getFirstChild();
            root.insertBefore(comment, firstChild);
        }
        return origSpec;
    }
}

