/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import java.io.File;
import java.util.Hashtable;
import org.w3c.dom.Document;

public class SchemaModelCache {
    private Hashtable<String, SchemaModelImpl> schemaModelForNamespace = new Hashtable();

    private SchemaModelImpl createSchemaModel(String schemaNamespace, IConfiguration config) throws UpgradeException {
        File schemaFile = config.getReportSpecificationSchemaFile(schemaNamespace);
        if (schemaFile == null) {
            return null;
        }
        try {
            Document schemaDoc = XmlUtils.readDocument(schemaFile);
            SchemaModelImpl schema = new SchemaModelImpl(schemaDoc);
            return schema;
        }
        catch (IOException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
        catch (SchemaException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private void ensureSchemaModelIsLoaded(String schemaNamespace, IConfiguration config) throws UpgradeException {
        if (!this.schemaModelForNamespace.containsKey(schemaNamespace)) {
            SchemaModelImpl loadedSchema = this.createSchemaModel(schemaNamespace, config);
            if (loadedSchema == null) {
                return;
            }
            this.schemaModelForNamespace.put(schemaNamespace, loadedSchema);
        }
    }

    public synchronized SchemaModelImpl getModel(IConfiguration config, String schemaNamespace) throws UpgradeException {
        if (schemaNamespace == null) {
            return null;
        }
        this.ensureSchemaModelIsLoaded(schemaNamespace, config);
        return this.schemaModelForNamespace.get(schemaNamespace);
    }
}

