/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AbortSchemaValidation;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.RestartSchemaValidation;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SchemaValidator {
    private SchemaModel schema = null;
    private IConfiguration config = null;
    private Log log;

    protected SchemaValidator(IConfiguration config, SchemaModel schema, Log aLog) throws UpgradeException {
        if (aLog == null) {
            throw new UpgradeInternalErrorException("Log may not be null");
        }
        this.config = config;
        this.schema = schema;
        this.log = aLog;
    }

    public Document validateAndFix(Document doc) throws UpgradeException {
        try {
            SchemaDocumentFixer docFixer = new SchemaDocumentFixer();
            this.schema.validateAndFix(doc, docFixer);
            XmlUtils.writeIntermediateDocument(doc, "after_fixup", this.config);
        }
        catch (Exception ex) {
            UpgradeException.throwNestedException(ex);
        }
        return doc;
    }

    protected Log getLog() {
        return this.log;
    }

    private class SchemaDocumentFixer
    implements DocumentFixer {
        final int maxNbErrors;
        int nbErrors;

        private SchemaDocumentFixer() {
            this.maxNbErrors = SchemaValidator.this.config.getMaxSchemaFixups();
            this.nbErrors = 0;
        }

        @Override
        public void invalidValue(Attr attr, String validValue) throws AbortSchemaValidation {
            this.countErrors();
            String attributeName = attr.getName();
            String oldValue = attr.getValue();
            attr.setValue(validValue);
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_ATTRIBUTE_VALUE_CHANGED(attributeName, validValue, oldValue));
            XmlUtils.insertComment(attr.getOwnerElement(), msg);
        }

        @Override
        public void removeAttribute(Attr attr) throws AbortSchemaValidation {
            this.countErrors();
            Element parent = attr.getOwnerElement();
            String elementName = parent.getTagName();
            String attributeName = attr.getName();
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_ATTRIBUTE_REMOVED(attributeName, elementName));
            XmlUtils.insertComment(attr, msg);
            parent.removeAttribute(attributeName);
        }

        @Override
        public Attr createAttribute(Element element, String attributeName, String validValue) throws AbortSchemaValidation {
            this.countErrors();
            Document doc = XmlUtils.getOwnerDoc(element);
            Attr newAttribute = doc.createAttribute(attributeName);
            newAttribute.setValue(validValue);
            element.setAttributeNode(newAttribute);
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_ATTRIBUTE_CREATED(attributeName));
            XmlUtils.insertComment(element, msg);
            return newAttribute;
        }

        @Override
        public Node remove(Node node) throws AbortSchemaValidation {
            this.countErrors();
            Node sibling = node.getNextSibling();
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_NODE_REMOVED());
            XmlUtils.commentOut(node, msg);
            return sibling;
        }

        @Override
        public void createRoot(Document doc) throws AbortSchemaValidation {
            this.createElement(doc, null, "report");
        }

        @Override
        public Element createElement(Node parent, Node insertBefore, String elementName) throws AbortSchemaValidation {
            this.countErrors();
            Document doc = XmlUtils.getOwnerDoc(parent);
            Element newElement = doc.createElementNS(SchemaValidator.this.schema.getTargetNamespace(), elementName);
            parent.insertBefore(newElement, insertBefore);
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_ELEMENT_CREATED(elementName));
            XmlUtils.insertComment(newElement, msg);
            return newElement;
        }

        @Override
        public Text createText(Node parent, Node insertBefore, String textContent) throws AbortSchemaValidation {
            this.countErrors();
            Document doc = XmlUtils.getOwnerDoc(parent);
            Text text = doc.createTextNode(textContent);
            parent.insertBefore(text, insertBefore);
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_TEXT_CREATED(textContent));
            XmlUtils.insertComment(text, msg);
            return text;
        }

        @Override
        public void invalidValue(Text text, String validValue) throws AbortSchemaValidation {
            this.countErrors();
            String oldValue = text.getData();
            text.setData(validValue);
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_TEXT_CHANGED(validValue, oldValue));
            XmlUtils.insertComment(text, msg);
        }

        @Override
        public void keyNotUnique(Element element, String keyId, Vector<Object> keySequence) throws AbortSchemaValidation {
            this.countErrors();
            String key = keySequence.toString();
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_KEY_CONSTRAINT_NON_UNIQUE(keyId, key));
            XmlUtils.commentOut(element, msg);
            throw new RestartSchemaValidation();
        }

        @Override
        public void keyFieldMissing(Element element, String keyName, String fieldId) throws AbortSchemaValidation {
            this.countErrors();
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_KEY_CONSTRAINT_FIELD_MISSING(keyName, fieldId));
            XmlUtils.commentOut(element, msg);
            throw new RestartSchemaValidation();
        }

        @Override
        public void keyrefMissing(Element element, String keyrefName, Vector<Object> keySequence) throws AbortSchemaValidation {
            this.countErrors();
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            for (int i = 0; i < keySequence.size(); ++i) {
                buffer.append(keySequence.get(i));
                buffer.append(' ');
            }
            buffer.append("}");
            String key = buffer.toString();
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_KEYREF_CONSTRAINT_KEY_NOT_FOUND(keyrefName, key));
            XmlUtils.commentOut(element, msg);
            throw new RestartSchemaValidation();
        }

        @Override
        public void keyrefMissingField(Element element, String keyrefName, String missingField) throws AbortSchemaValidation {
            this.countErrors();
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_KEYREF_CONSTRAINT_MISSING_FIELD(keyrefName, missingField));
            XmlUtils.commentOut(element, msg);
            throw new RestartSchemaValidation();
        }

        @Override
        public void notUnique(Node node, String constraintName) throws AbortSchemaValidation {
            this.countErrors();
            Log log = SchemaValidator.this.getLog();
            String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_UNIQUE_CONSTRAINT_VIOLATED(constraintName));
            XmlUtils.commentOut(node, msg);
            throw new RestartSchemaValidation();
        }

        private void countErrors() throws AbortSchemaValidation {
            ++this.nbErrors;
            if (this.nbErrors > this.maxNbErrors) {
                Log log = SchemaValidator.this.getLog();
                String msg = log.error(RspecUpgradeMessage.RSU_SPC_SCHEMA_FIXUP_ABORTED_TOO_MANY_ERRORS(Integer.toString(this.nbErrors)));
                throw new AbortSchemaValidation(msg);
            }
        }
    }
}

